/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder;

import com.swinglayoutbuilder.AbstractBuilder;
import com.swinglayoutbuilder.constraintlayout.Constraint;
import com.swinglayoutbuilder.constraintlayout.ConstraintLayout;
import com.swinglayoutbuilder.constraintlayout.ConstraintLayoutGroup;
import com.swinglayoutbuilder.constraintlayout.Edge;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

public class ConstraintLayoutBuilder
extends AbstractBuilder {
    private Component previousComponent;
    private Component currentComponent;
    private Component anchor1Component;
    private Component anchor2Component;
    private Component anchor3Component;
    private ConstraintLayoutGroup currentGroup;
    private final Map<String, Component> id2ComponentMap = new HashMap<String, Component>();
    private final ConstraintLayout layout = new ConstraintLayout();
    private int gapBetweenComponents;

    protected ConstraintLayoutBuilder(Container container) {
        super(container);
        container.setLayout(this.layout);
    }

    public ConstraintLayoutBuilder gapBetweenComponents(int value) {
        this.gapBetweenComponents = value;
        return this;
    }

    public ConstraintLayoutBuilder createGroup(String id) {
        ConstraintLayoutGroup group = this.layout.createGroup();
        if (this.id2ComponentMap.containsKey(id)) {
            throw new IllegalArgumentException("Component/group with id [" + id + "] is already present in builder");
        }
        this.currentGroup = group;
        this.add(id, group);
        return this;
    }

    public ConstraintLayoutBuilder addToCurrentGroup() {
        this.checkCurrentComponent();
        this.checkCurrentGroup();
        this.currentGroup.addComponent(this.currentComponent);
        return this;
    }

    public ConstraintLayoutBuilder addToGroup(String componentId, String groupId) {
        Component componentToAdd = this.getComponentById(componentId);
        Component groupComponent = this.getComponentById(groupId);
        if (!(groupComponent instanceof ConstraintLayoutGroup)) {
            throw new IllegalArgumentException("Component with id [" + groupId + "] is not group");
        }
        ConstraintLayoutGroup group = (ConstraintLayoutGroup)groupComponent;
        group.addComponent(componentToAdd);
        return this;
    }

    public ConstraintLayoutBuilder addToGroup(String groupId) {
        this.checkCurrentComponent();
        Component groupComponent = this.getComponentById(groupId);
        if (!(groupComponent instanceof ConstraintLayoutGroup)) {
            throw new IllegalArgumentException("Component with id [" + groupId + "] is not group");
        }
        ConstraintLayoutGroup group = (ConstraintLayoutGroup)groupComponent;
        group.addComponent(this.currentComponent);
        return this;
    }

    public ConstraintLayoutBuilder globalMargin(int top, int left, int bottom, int right) {
        this.layout.setMargin(top, left, bottom, right);
        return this;
    }

    public ConstraintLayoutBuilder id(String id) {
        this.checkCurrentComponent();
        if (this.id2ComponentMap.containsKey(id)) {
            throw new IllegalArgumentException("Component/group with id [" + id + "] is already present in builder");
        }
        this.id2ComponentMap.put(id, this.currentComponent);
        return this;
    }

    public ConstraintLayoutBuilder anchor1() {
        this.checkCurrentComponent();
        this.anchor1Component = this.currentComponent;
        return this;
    }

    public ConstraintLayoutBuilder anchor2() {
        this.checkCurrentComponent();
        this.anchor2Component = this.currentComponent;
        return this;
    }

    public ConstraintLayoutBuilder anchor3() {
        this.checkCurrentComponent();
        this.anchor3Component = this.currentComponent;
        return this;
    }

    public ConstraintLayoutBuilder add(Component component) {
        this.add(null, component);
        return this;
    }

    public ConstraintLayoutBuilder add(String id, Component component) {
        this.container.add(component);
        this.previousComponent = this.currentComponent;
        this.currentComponent = component;
        if (id != null) {
            this.id(id);
        }
        return this;
    }

    public ConstraintLayoutBuilder link(Component component, Edge edge, String anchorComponentId, Edge anchorEdge, int gap) {
        this.layout.addConstraint(new Constraint(anchorEdge, this.getComponentById(anchorComponentId), gap, edge, component));
        return this;
    }

    public ConstraintLayoutBuilder linkToId(Edge edge, String anchorComponentId, Edge anchorEdge) {
        this.checkCurrentComponent();
        return this.link(this.currentComponent, edge, anchorComponentId, anchorEdge, this.gapBetweenComponents);
    }

    public ConstraintLayoutBuilder linkToId(Edge edge, String anchorComponentId, Edge anchorEdge, int gap) {
        this.checkCurrentComponent();
        return this.link(this.currentComponent, edge, anchorComponentId, anchorEdge, gap);
    }

    public ConstraintLayoutBuilder linkIdToId(String componentId, Edge edge, String anchorComponentId, Edge anchorEdge) {
        Component component = this.getComponentById(componentId);
        return this.link(component, edge, anchorComponentId, anchorEdge, this.gapBetweenComponents);
    }

    public ConstraintLayoutBuilder linkIdToId(String componentId, Edge edge, String anchorComponentId, Edge anchorEdge, int gap) {
        Component component = this.getComponentById(componentId);
        return this.link(component, edge, anchorComponentId, anchorEdge, gap);
    }

    public ConstraintLayoutBuilder linkToParent(Edge edge, Edge parentEdge) {
        this.checkCurrentComponent();
        this.layout.addConstraint(new Constraint(parentEdge, this.container, this.gapBetweenComponents, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToParent(Edge edge, Edge parentEdge, int gap) {
        this.checkCurrentComponent();
        this.layout.addConstraint(new Constraint(parentEdge, this.container, gap, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToPrevious(Edge edge, Edge previousComponentEdge) {
        this.checkCurrentComponent();
        this.checkPreviousComponent();
        this.layout.addConstraint(new Constraint(previousComponentEdge, this.previousComponent, this.gapBetweenComponents, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToPrevious(Edge edge, Edge previousComponentEdge, int gap) {
        this.checkCurrentComponent();
        this.checkPreviousComponent();
        this.layout.addConstraint(new Constraint(previousComponentEdge, this.previousComponent, gap, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor1(Edge edge, Edge anchor1ComponentEdge) {
        this.checkCurrentComponent();
        this.checkAnchor1Component();
        this.layout.addConstraint(new Constraint(anchor1ComponentEdge, this.anchor1Component, this.gapBetweenComponents, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor1(Edge edge, Edge anchor1ComponentEdge, int gap) {
        this.checkCurrentComponent();
        this.checkAnchor1Component();
        this.layout.addConstraint(new Constraint(anchor1ComponentEdge, this.anchor1Component, gap, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor2(Edge edge, Edge anchor2ComponentEdge) {
        this.checkCurrentComponent();
        this.checkAnchor2Component();
        this.layout.addConstraint(new Constraint(anchor2ComponentEdge, this.anchor2Component, this.gapBetweenComponents, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor2(Edge edge, Edge anchor2ComponentEdge, int gap) {
        this.checkCurrentComponent();
        this.checkAnchor2Component();
        this.layout.addConstraint(new Constraint(anchor2ComponentEdge, this.anchor2Component, gap, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor3(Edge edge, Edge anchor3ComponentEdge) {
        this.checkCurrentComponent();
        this.checkAnchor3Component();
        this.layout.addConstraint(new Constraint(anchor3ComponentEdge, this.anchor3Component, this.gapBetweenComponents, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder linkToAnchor3(Edge edge, Edge anchor3ComponentEdge, int gap) {
        this.checkCurrentComponent();
        this.checkAnchor3Component();
        this.layout.addConstraint(new Constraint(anchor3ComponentEdge, this.anchor3Component, gap, edge, this.currentComponent));
        return this;
    }

    public ConstraintLayoutBuilder preferredSize(int width, int height) {
        this.currentComponent.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public ConstraintLayoutBuilder minimumSize(int width, int height) {
        this.currentComponent.setMinimumSize(new Dimension(width, height));
        return this;
    }

    public ConstraintLayoutBuilder maximumSize(int width, int height) {
        this.currentComponent.setMaximumSize(new Dimension(width, height));
        return this;
    }

    private Component getComponentById(String id) {
        if (id.equals("ConstraintLayoutBuilder_PARENT")) {
            return this.container;
        }
        if (!this.id2ComponentMap.containsKey(id)) {
            throw new IllegalArgumentException("Cannot find component with id=" + id);
        }
        return this.id2ComponentMap.get(id);
    }

    private void throwIfNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalStateException(message);
        }
    }

    private void checkCurrentComponent() {
        this.throwIfNull(this.currentComponent, "There is no current component");
    }

    private void checkPreviousComponent() {
        this.throwIfNull(this.previousComponent, "There is no previous component");
    }

    private void checkAnchor1Component() {
        this.throwIfNull(this.anchor1Component, "There is no anchor1 component");
    }

    private void checkAnchor2Component() {
        this.throwIfNull(this.anchor2Component, "There is no anchor2 component");
    }

    private void checkAnchor3Component() {
        this.throwIfNull(this.anchor3Component, "There is no anchor3 component");
    }

    private void checkCurrentGroup() {
        this.throwIfNull(this.currentGroup, "There is no current group");
    }
}

