/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder;

import com.swinglayoutbuilder.AbstractBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class BorderLayoutBuilder
extends AbstractBuilder {
    private final BorderLayout layout = new BorderLayout(0, 0);
    private Component currentComponent;

    protected BorderLayoutBuilder(Container container) {
        super(container);
        container.setLayout(this.layout);
    }

    public BorderLayoutBuilder gapBetweenComponents(int hor, int ver) {
        this.layout.setHgap(hor);
        this.layout.setVgap(ver);
        return this;
    }

    public BorderLayoutBuilder addToCenter(Component component) {
        this.container.add(component);
        this.currentComponent = component;
        return this;
    }

    public BorderLayoutBuilder addToLeft(Component component) {
        this.container.add(component, "West");
        this.currentComponent = component;
        return this;
    }

    public BorderLayoutBuilder addToRight(Component component) {
        this.container.add(component, "East");
        this.currentComponent = component;
        return this;
    }

    public BorderLayoutBuilder addToTop(Component component) {
        this.container.add(component, "North");
        this.currentComponent = component;
        return this;
    }

    public BorderLayoutBuilder addToBottom(Component component) {
        this.container.add(component, "South");
        this.currentComponent = component;
        return this;
    }

    public BorderLayoutBuilder preferredSize(int width, int height) {
        this.currentComponent.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public BorderLayoutBuilder minimumSize(int width, int height) {
        this.currentComponent.setMinimumSize(new Dimension(width, height));
        return this;
    }

    public BorderLayoutBuilder maximumSize(int width, int height) {
        this.currentComponent.setMaximumSize(new Dimension(width, height));
        return this;
    }

    @Override
    public Container finish() {
        return this.container;
    }
}

