/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input.structured;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplateCustomizer;
import dev.langchain4j.model.input.structured.DefaultStructuredPromptFactory;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.prompt.structured.StructuredPromptFactory;
import java.util.Iterator;

public class StructuredPromptProcessor {
    private static final PromptTemplateCustomizer CUSTOMIZER = StructuredPromptProcessor.templateCustomizer();
    private static final StructuredPromptFactory FACTORY = StructuredPromptProcessor.factory();

    private StructuredPromptProcessor() {
    }

    private static StructuredPromptFactory factory() {
        Iterator<StructuredPromptFactory> iterator = ServiceHelper.loadFactories(StructuredPromptFactory.class).iterator();
        if (iterator.hasNext()) {
            StructuredPromptFactory factory = iterator.next();
            return factory;
        }
        return new DefaultStructuredPromptFactory(CUSTOMIZER);
    }

    private static PromptTemplateCustomizer templateCustomizer() {
        Iterator<PromptTemplateCustomizer> iterator = ServiceHelper.loadFactories(PromptTemplateCustomizer.class).iterator();
        if (iterator.hasNext()) {
            PromptTemplateCustomizer customizer = iterator.next();
            return customizer;
        }
        return template -> template;
    }

    public static Prompt toPrompt(Object structuredPrompt) {
        return FACTORY.toPrompt(structuredPrompt);
    }
}

