/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.extend;

import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.simple.NoNamespaceHandler;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.XRLog;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XhtmlCssOnlyNamespaceHandler
extends NoNamespaceHandler {
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final String PATH_TO_DEFAULT_STYLESHEET = "/resources/css/XhtmlNamespaceHandler.css";
    private static StylesheetInfo _defaultStylesheet;
    private static boolean _defaultStylesheetError;
    private String _contentLanguageMetaValue;

    @Override
    public String getNamespace() {
        return XHTML_NAMESPACE;
    }

    @Override
    public String getClass(Element e) {
        return e.getAttribute("class");
    }

    @Override
    public String getID(Element e) {
        String result = e.getAttribute("id").trim();
        return result.length() == 0 ? null : result;
    }

    protected String convertToLength(String value) {
        if (this.isInteger(value)) {
            return value + "px";
        }
        return value;
    }

    protected boolean isInteger(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    protected String getAttribute(Element e, String attrName) {
        String result = e.getAttribute(attrName);
        return (result = result.trim()).length() == 0 ? null : result;
    }

    private static String readTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            short nodeType = current.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            Text t = (Text)current;
            result.append(t.getData());
        }
        return result.toString();
    }

    private static String collapseWhiteSpace(String text) {
        StringBuilder result = new StringBuilder();
        int l = text.length();
        block0: for (int i = 0; i < l; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                result.append(' ');
                while (++i < l) {
                    c = text.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    --i;
                    continue block0;
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public String getLinkUri(Element e) {
        String href = null;
        if (e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("href")) {
            href = e.getAttribute("href");
        }
        return href;
    }

    @Override
    public String getAnchorName(Element e) {
        if (e != null && e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("name")) {
            return e.getAttribute("name");
        }
        return null;
    }

    @Override
    public String getElementStyling(Element e) {
        StringBuilder style = new StringBuilder();
        if (e.getNodeName().equals("td") || e.getNodeName().equals("th")) {
            String s = this.getAttribute(e, "colspan");
            if (s != null) {
                style.append("-fs-table-cell-colspan: ");
                style.append(s);
                style.append(";");
            }
            if ((s = this.getAttribute(e, "rowspan")) != null) {
                style.append("-fs-table-cell-rowspan: ");
                style.append(s);
                style.append(";");
            }
        } else if (e.getNodeName().equals("img")) {
            String s = this.getAttribute(e, "width");
            if (s != null) {
                style.append("width: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
            if ((s = this.getAttribute(e, "height")) != null) {
                style.append("height: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
        } else if (e.getNodeName().equals("colgroup") || e.getNodeName().equals("col")) {
            String s = this.getAttribute(e, "span");
            if (s != null) {
                style.append("-fs-table-cell-colspan: ");
                style.append(s);
                style.append(";");
            }
            if ((s = this.getAttribute(e, "width")) != null) {
                style.append("width: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
        }
        style.append(e.getAttribute("style"));
        return style.toString();
    }

    @Override
    public String getDocumentTitle(Document doc) {
        Element titleElem;
        String title = "";
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null && (titleElem = this.findFirstChild(head, "title")) != null) {
            title = XhtmlCssOnlyNamespaceHandler.collapseWhiteSpace(XhtmlCssOnlyNamespaceHandler.readTextContent(titleElem).trim());
        }
        return title;
    }

    private Element findFirstChild(Element parent, String targetName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(targetName)) continue;
            return (Element)n;
        }
        return null;
    }

    protected StylesheetInfo readStyleElement(Element style) {
        StylesheetInfo info = new StylesheetInfo();
        info.setMedia(style.getAttribute("media"));
        info.setType(style.getAttribute("type"));
        info.setTitle(style.getAttribute("title"));
        info.setOrigin(2);
        StringBuilder buf = new StringBuilder();
        for (Node current = style.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!(current instanceof CharacterData)) continue;
            buf.append(((CharacterData)current).getData());
        }
        String css = buf.toString().trim();
        if (css.isEmpty()) {
            return null;
        }
        info.setContent(css);
        return info;
    }

    protected StylesheetInfo readLinkElement(Element link) {
        String rel = link.getAttribute("rel").toLowerCase();
        if (rel.contains("alternate")) {
            return null;
        }
        if (!rel.contains("stylesheet")) {
            return null;
        }
        String type = link.getAttribute("type");
        if (!type.isEmpty() && !type.equals("text/css")) {
            return null;
        }
        if (type.isEmpty()) {
            type = "text/css";
            XRLog.log(Level.FINE, LogMessageId.LogMessageId1Param.CSS_PARSE_LINK_TYPE_UNSPECIFIED, link.getAttribute("href"));
        }
        StylesheetInfo info = new StylesheetInfo();
        info.setType(type);
        info.setOrigin(2);
        info.setUri(link.getAttribute("href"));
        String media = link.getAttribute("media");
        info.setMedia(media);
        String title = link.getAttribute("title");
        info.setTitle(title);
        return info;
    }

    @Override
    public StylesheetInfo[] getStylesheets(Document doc) {
        ArrayList<StylesheetInfo> result = new ArrayList<StylesheetInfo>();
        result.addAll(Arrays.asList(super.getStylesheets(doc)));
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                StylesheetInfo info = null;
                String elemName = elem.getLocalName();
                if (elemName == null) {
                    elemName = elem.getTagName();
                }
                if (elemName.equals("link")) {
                    info = this.readLinkElement(elem);
                } else if (elemName.equals("style")) {
                    info = this.readStyleElement(elem);
                }
                if (info == null) continue;
                result.add(info);
            }
        }
        return result.toArray(new StylesheetInfo[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StylesheetInfo getDefaultStylesheet(StylesheetFactory factory) {
        Class<XhtmlCssOnlyNamespaceHandler> clazz = XhtmlCssOnlyNamespaceHandler.class;
        synchronized (XhtmlCssOnlyNamespaceHandler.class) {
            if (_defaultStylesheet != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return _defaultStylesheet;
            }
            if (_defaultStylesheetError) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            StylesheetInfo info = new StylesheetInfo();
            info.setUri("classpath:" + this.getPathToDefaultStylesheet());
            info.setOrigin(0);
            info.setMedia("all");
            info.setType("text/css");
            InputStream inputStream = null;
            try {
                inputStream = this.getDefaultStylesheetStream();
                if (_defaultStylesheetError) {
                    StylesheetInfo stylesheetInfo = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return stylesheetInfo;
                }
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    Stylesheet sheet = factory.parse(reader, info);
                    info.setStylesheet(sheet);
                }
            }
            catch (Exception e) {
                _defaultStylesheetError = true;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.EXCEPTION_COULD_NOT_PARSE_DEFAULT_STYLESHEET, e);
            }
            finally {
                OpenUtil.closeQuietly(inputStream);
            }
            _defaultStylesheet = info;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _defaultStylesheet;
        }
    }

    protected String getPathToDefaultStylesheet() {
        return PATH_TO_DEFAULT_STYLESHEET;
    }

    private InputStream getDefaultStylesheetStream() {
        String pathToStylesheet = this.getPathToDefaultStylesheet();
        InputStream stream = this.getClass().getResourceAsStream(pathToStylesheet);
        if (stream == null) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_DEFAULT_CSS, pathToStylesheet);
            _defaultStylesheetError = true;
        }
        return stream;
    }

    private Map<String, String> getMetaInfo(Document doc) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                String elemName = elem.getLocalName();
                if (elemName == null) {
                    elemName = elem.getTagName();
                }
                if (!elemName.equals("meta")) continue;
                String http_equiv = elem.getAttribute("http-equiv");
                String content = elem.getAttribute("content");
                if (http_equiv.equals("") || content.equals("")) continue;
                metadata.put(http_equiv, content);
            }
        }
        return metadata;
    }

    private String getContentLanguageMetaTag(Document doc) {
        if (this._contentLanguageMetaValue == null) {
            String possible = this.getMetaInfo(doc).get("Content-Language");
            this._contentLanguageMetaValue = possible != null ? possible : "";
        }
        return this._contentLanguageMetaValue;
    }

    @Override
    public String getLang(Element e) {
        String lang = e.getAttribute("lang");
        if (lang.isEmpty()) {
            Node parent = e.getParentNode();
            if (parent instanceof Element) {
                return this.getLang((Element)parent);
            }
            return this.getContentLanguageMetaTag(e.getOwnerDocument());
        }
        return lang;
    }

    static {
        _defaultStylesheetError = false;
    }
}

