/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.JoinType;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.hibernate.StatelessSessionHolder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;

public class HibernateUpdateClause
implements UpdateClause<HibernateUpdateClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final Map<Path<?>, Expression<?>> updates = new LinkedHashMap();
    private final SessionHolder session;
    private final JPQLTemplates templates;
    private final Map<Path<?>, LockMode> lockModes = new HashMap();

    public HibernateUpdateClause(Session session, EntityPath<?> entity) {
        this(new DefaultSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateUpdateClause(StatelessSession session, EntityPath<?> entity) {
        this(new StatelessSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateUpdateClause(Session session, EntityPath<?> entity, JPQLTemplates templates) {
        this(new DefaultSessionHolder(session), entity, templates);
    }

    public HibernateUpdateClause(SessionHolder session, EntityPath<?> entity, JPQLTemplates templates) {
        this.session = session;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForUpdate(this.queryMixin.getMetadata(), this.updates);
        Query<?> query = this.session.createQuery(serializer.toString());
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        HibernateUtil.setConstants(query, serializer.getConstants(), this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    public <T> HibernateUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.updates.put(path, Expressions.constant(value));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> HibernateUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.updates.put(path, expression);
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> HibernateUpdateClause setNull(Path<T> path) {
        this.updates.put(path, (Expression<?>)Expressions.nullExpression(path));
        return this;
    }

    public HibernateUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.updates.put(paths.get(i), Expressions.constant(values.get(i)));
                continue;
            }
            this.updates.put(paths.get(i), (Expression<?>)Expressions.nullExpression(paths.get(i)));
        }
        return this;
    }

    public HibernateUpdateClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.queryMixin.where(p);
        }
        return this;
    }

    public HibernateUpdateClause setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForUpdate(this.queryMixin.getMetadata(), this.updates);
        return serializer.toString();
    }

    public boolean isEmpty() {
        return this.updates.isEmpty();
    }
}

