/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.DefaultEntitySerializer;
import com.querydsl.codegen.EmbeddableSerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class DefaultEmbeddableSerializer
extends DefaultEntitySerializer
implements EmbeddableSerializer {
    @Inject
    public DefaultEmbeddableSerializer(TypeMappings typeMappings, @Named(value="keywords") Collection<String> keywords, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        super(typeMappings, keywords, generatedAnnotationClass);
    }

    public DefaultEmbeddableSerializer(TypeMappings typeMappings, Collection<String> keywords) {
        this(typeMappings, keywords, GeneratedAnnotationResolver.resolveDefault());
    }

    @Override
    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class<BeanPath> pathType;
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            pathType = switch (category) {
                case TypeCategory.COMPARABLE -> ComparablePath.class;
                case TypeCategory.ENUM -> EnumPath.class;
                case TypeCategory.DATE -> DatePath.class;
                case TypeCategory.DATETIME -> DateTimePath.class;
                case TypeCategory.TIME -> TimePath.class;
                case TypeCategory.NUMERIC -> NumberPath.class;
                case TypeCategory.STRING -> StringPath.class;
                case TypeCategory.BOOLEAN -> BooleanPath.class;
                default -> BeanPath.class;
            };
        } else {
            pathType = BeanPath.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.suppressWarnings("this-escape");
        writer.line(new String[]{"@", this.generatedAnnotationClass.getSimpleName(), "(\"", this.getClass().getName(), "\")"});
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, (Type)new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, (Type)new ClassType(category, pathType, new Type[]{model}), new Type[0]);
        }
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", model.hashCode() + "L");
    }
}

