/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.Type;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroovyBeanSerializer
implements Serializer {
    private final boolean propertyAnnotations;
    private final String javadocSuffix;
    private boolean printSupertype = false;

    public GroovyBeanSerializer() {
        this(true, " is a Querydsl bean type");
    }

    public GroovyBeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public GroovyBeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a Querydsl bean type");
    }

    public GroovyBeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[0]));
        writer.javadoc(new String[]{simpleName + this.javadocSuffix});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        if (this.printSupertype && model.getSuperType() != null) {
            writer.beginClass((Type)model, model.getSuperType().getType(), new Type[0]);
        } else {
            writer.beginClass((Type)model);
        }
        this.bodyStart(model, writer);
        for (Property property : model.getProperties()) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            writer.field(property.getType(), property.getEscapedName());
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void setPrintSupertype(boolean printSupertype) {
        this.printSupertype = printSupertype;
    }
}

