/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.apt.jpa;

import com.querydsl.apt.DefaultConfiguration;
import com.querydsl.apt.QueryTypeImpl;
import com.querydsl.apt.TypeUtils;
import com.querydsl.apt.VisitorConfig;
import com.querydsl.codegen.Keywords;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryEntities;
import com.querydsl.core.annotations.QueryInit;
import com.querydsl.core.annotations.QueryTransient;
import com.querydsl.core.annotations.QueryType;
import com.querydsl.core.util.Annotations;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class JPAConfiguration
extends DefaultConfiguration {
    private final List<Class<? extends Annotation>> annotations = this.getAnnotations();
    private final Types types;

    public JPAConfiguration(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> embeddedAnn, Class<? extends Annotation> skipAnn) {
        super(processingEnv, roundEnv, (Collection<String>)Keywords.JPA, QueryEntities.class, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn);
        this.types = processingEnv.getTypeUtils();
        this.setStrictMode(true);
    }

    protected List<Class<? extends Annotation>> getAnnotations() {
        return List.of(Access.class, Basic.class, Column.class, ElementCollection.class, Embedded.class, EmbeddedId.class, Enumerated.class, GeneratedValue.class, Id.class, JoinColumn.class, ManyToOne.class, ManyToMany.class, MapKeyEnumerated.class, OneToOne.class, OneToMany.class, PrimaryKeyJoinColumn.class, QueryType.class, QueryInit.class, QueryTransient.class, Temporal.class, Transient.class, Version.class);
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        Access access = e.getAnnotation(Access.class);
        if (access != null) {
            if (access.value() == AccessType.FIELD) {
                return VisitorConfig.FIELDS_ONLY;
            }
            return VisitorConfig.METHODS_ONLY;
        }
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (!this.hasRelevantAnnotation(element)) continue;
            fields |= element.getKind().equals((Object)ElementKind.FIELD);
            methods |= element.getKind().equals((Object)ElementKind.METHOD);
        }
        return VisitorConfig.get(fields, methods, VisitorConfig.ALL);
    }

    @Override
    public TypeMirror getRealType(ExecutableElement method) {
        return this.getRealElementType(method);
    }

    @Override
    public TypeMirror getRealType(VariableElement field) {
        return this.getRealElementType(field);
    }

    private TypeMirror getRealElementType(Element element) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirrorOfType(element, ManyToOne.class);
        if (mirror == null) {
            mirror = TypeUtils.getAnnotationMirrorOfType(element, OneToOne.class);
        }
        if (mirror != null) {
            return TypeUtils.getAnnotationValueAsTypeMirror(mirror, "targetEntity");
        }
        mirror = TypeUtils.getAnnotationMirrorOfType(element, OneToMany.class);
        if (mirror == null) {
            mirror = TypeUtils.getAnnotationMirrorOfType(element, ManyToMany.class);
        }
        if (mirror != null) {
            TypeMirror erasure;
            TypeMirror typeArg = TypeUtils.getAnnotationValueAsTypeMirror(mirror, "targetEntity");
            if (element instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)element;
                erasure = executableElement.getReturnType();
            } else {
                erasure = this.types.erasure(element.asType());
            }
            TypeElement typeElement = (TypeElement)this.types.asElement(erasure);
            if (typeElement != null && typeArg != null) {
                if (typeElement.getTypeParameters().size() == 1) {
                    return this.types.getDeclaredType(typeElement, typeArg);
                }
                if (typeElement.getTypeParameters().size() == 2 && element.asType() instanceof DeclaredType) {
                    TypeMirror first = ((DeclaredType)element.asType()).getTypeArguments().get(0);
                    return this.types.getDeclaredType(typeElement, first, typeArg);
                }
            }
        }
        return null;
    }

    @Override
    public void inspect(Element element, Annotations annotations) {
        Temporal temporal = element.getAnnotation(Temporal.class);
        if (temporal != null && element.getAnnotation(ElementCollection.class) == null) {
            PropertyType propertyType = null;
            switch (temporal.value()) {
                case DATE: {
                    propertyType = PropertyType.DATE;
                    break;
                }
                case TIME: {
                    propertyType = PropertyType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    propertyType = PropertyType.DATETIME;
                }
            }
            annotations.addAnnotation((Annotation)((Object)new QueryTypeImpl(propertyType)));
        }
    }

    private boolean hasRelevantAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

