/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import feign.form.MultipartFormContentProcessor;
import feign.form.UrlencodedFormContentProcessor;
import feign.form.util.CharsetUtil;
import feign.form.util.PojoUtil;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormEncoder
implements Encoder {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?<=charset=)([\\w\\-]+)");
    private final Encoder delegate;
    private final Map<ContentType, ContentProcessor> processors;

    public FormEncoder() {
        this((Encoder)new Encoder.Default());
    }

    public FormEncoder(Encoder delegate) {
        this.delegate = delegate;
        List<ContentProcessor> list = Arrays.asList(new MultipartFormContentProcessor(delegate), new UrlencodedFormContentProcessor());
        this.processors = new HashMap<ContentType, ContentProcessor>(list.size(), 1.0f);
        for (ContentProcessor processor : list) {
            this.processors.put(processor.getSupportedContentType(), processor);
        }
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        Map<String, Object> data;
        String contentTypeValue = this.getContentTypeValue(template.headers());
        ContentType contentType = ContentType.of(contentTypeValue);
        if (!this.processors.containsKey((Object)contentType)) {
            this.delegate.encode(object, bodyType, template);
            return;
        }
        if (MAP_STRING_WILDCARD.equals(bodyType)) {
            data = (Map<String, Object>)object;
        } else if (PojoUtil.isUserPojo(object)) {
            data = PojoUtil.toMap(object);
        } else {
            this.delegate.encode(object, bodyType, template);
            return;
        }
        Charset charset = this.getCharset(contentTypeValue);
        this.processors.get((Object)contentType).process(template, charset, data);
    }

    public final ContentProcessor getContentProcessor(ContentType type) {
        return this.processors.get((Object)type);
    }

    private String getContentTypeValue(Map<String, Collection<String>> headers) {
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(CONTENT_TYPE_HEADER)) continue;
            for (String contentTypeValue : entry.getValue()) {
                if (contentTypeValue == null) continue;
                return contentTypeValue;
            }
        }
        return null;
    }

    private Charset getCharset(String contentTypeValue) {
        Matcher matcher = CHARSET_PATTERN.matcher(contentTypeValue);
        return matcher.find() ? Charset.forName(matcher.group(1)) : CharsetUtil.UTF_8;
    }
}

