/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.Util;
import feign.form.FormDataProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartEncodedDataProcessor
implements FormDataProcessor {
    public static final String CONTENT_TYPE = "multipart/form-data";
    private static final String CRLF = "\r\n";

    @Override
    public void process(Map<String, Object> data, RequestTemplate template) {
        String boundary = this.createBoundary();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(outputStream);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                writer.append("--" + boundary).append(CRLF);
                if (this.isFile(entry.getValue())) {
                    this.writeFile((OutputStream)outputStream, writer, entry.getKey(), entry.getValue());
                } else {
                    this.writeParameter(writer, entry.getKey(), entry.getValue().toString());
                }
                writer.append(CRLF).flush();
            }
            writer.append("--" + boundary + "--").append(CRLF).flush();
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        String contentType = CONTENT_TYPE + "; boundary=" + boundary;
        template.header("Content-Type", new String[]{contentType});
        template.body(outputStream.toByteArray(), Util.UTF_8);
        outputStream.close();
    }

    @Override
    public String getSupportetContentType() {
        return CONTENT_TYPE;
    }

    protected boolean isFile(Object value) {
        return value != null && (value instanceof File || value instanceof byte[]);
    }

    protected void writeFile(OutputStream output, PrintWriter writer, String name, Object value) {
        if (value instanceof byte[]) {
            this.writeFile(output, writer, name, (byte[])value);
            return;
        }
        this.writeFile(output, writer, name, (File)value);
    }

    private String createBoundary() {
        return Long.toHexString(System.currentTimeMillis());
    }

    private void writeParameter(PrintWriter writer, String name, String value) {
        writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(CRLF);
        writer.append("Content-Type: text/plain; charset=UTF-8").append(CRLF);
        writer.append(CRLF).append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(OutputStream output, PrintWriter writer, String name, File file) {
        this.writeFileMeta(writer, name, file.getName());
        FileInputStream input = null;
        try {
            int length;
            input = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
        writer.flush();
    }

    private void writeFile(OutputStream output, PrintWriter writer, String name, byte[] bytes) {
        this.writeFileMeta(writer, name, "");
        output.write(bytes);
        writer.flush();
    }

    private void writeFileMeta(PrintWriter writer, String name, String fileName) {
        String contentDesposition = "Content-Disposition: form-data; name=\"" + name + "\"; " + "filename=\"" + fileName + "\"";
        String contentType = "Content-Type: " + URLConnection.guessContentTypeFromName(fileName);
        writer.append(contentDesposition).append(CRLF);
        writer.append(contentType).append(CRLF);
        writer.append("Content-Transfer-Encoding: binary").append(CRLF);
        writer.append(CRLF).flush();
    }
}

