/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.codec.Encoder;
import feign.form.FormDataProcessor;
import feign.form.FormEncodedDataProcessor;
import feign.form.MultipartEncodedDataProcessor;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FormEncoder
implements Encoder {
    private final Encoder deligate;
    private final Map<String, FormDataProcessor> processors;

    public FormEncoder() {
        this((Encoder)new Encoder.Default());
    }

    public FormEncoder(Encoder delegate) {
        this.deligate = delegate;
        this.processors = new HashMap<String, FormDataProcessor>(2, 1.0f);
        FormEncodedDataProcessor formEncodedDataProcessor = new FormEncodedDataProcessor();
        this.processors.put(formEncodedDataProcessor.getSupportetContentType(), formEncodedDataProcessor);
        MultipartEncodedDataProcessor multipartEncodedDataProcessor = new MultipartEncodedDataProcessor();
        this.processors.put(multipartEncodedDataProcessor.getSupportetContentType(), multipartEncodedDataProcessor);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        if (bodyType != MAP_STRING_WILDCARD) {
            this.deligate.encode(object, bodyType, template);
            return;
        }
        String formType = "";
        for (Map.Entry entry : template.headers().entrySet()) {
            if (!((String)entry.getKey()).equals("Content-Type")) continue;
            for (String contentType : (Collection)entry.getValue()) {
                if (!this.processors.containsKey(contentType)) continue;
                formType = contentType;
                break;
            }
            if (formType.isEmpty()) continue;
            break;
        }
        if (formType.isEmpty()) {
            this.deligate.encode(object, bodyType, template);
            return;
        }
        Map data = (Map)object;
        this.processors.get(formType).process(data, template);
    }
}

