/*
 * Decompiled with CFR 0.152.
 */
package feign.form.spring.converter;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.NonNull;
import org.springframework.web.multipart.MultipartFile;

final class ByteArrayMultipartFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    private final String contentType;
    @NonNull
    private final byte[] bytes;

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public long getSize() {
        return this.bytes.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void transferTo(File destination) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(destination);
        try {
            outputStream.write(this.bytes);
        }
        finally {
            outputStream.close();
        }
    }

    @ConstructorProperties(value={"name", "originalFilename", "contentType", "bytes"})
    public ByteArrayMultipartFile(String name, String originalFilename, String contentType, @NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.bytes = bytes;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    @NonNull
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArrayMultipartFile)) {
            return false;
        }
        ByteArrayMultipartFile other = (ByteArrayMultipartFile)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$originalFilename = this.getOriginalFilename();
        String other$originalFilename = other.getOriginalFilename();
        if (this$originalFilename == null ? other$originalFilename != null : !this$originalFilename.equals(other$originalFilename)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $originalFilename = this.getOriginalFilename();
        result = result * 59 + ($originalFilename == null ? 43 : $originalFilename.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }

    public String toString() {
        return "ByteArrayMultipartFile(name=" + this.getName() + ", originalFilename=" + this.getOriginalFilename() + ", contentType=" + this.getContentType() + ", bytes=" + Arrays.toString(this.getBytes()) + ")";
    }
}

