/*
 * Decompiled with CFR 0.152.
 */
package feign.form.spring;

import feign.codec.EncodeException;
import feign.form.MultipartEncodedDataProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.springframework.web.multipart.MultipartFile;

public class SpringMultipartEncodedDataProcessor
extends MultipartEncodedDataProcessor {
    protected boolean isPayload(Object value) {
        return super.isPayload(value) || value instanceof MultipartFile;
    }

    protected void writeByteOrFile(OutputStream output, PrintWriter writer, String name, Object value) {
        if (value instanceof MultipartFile) {
            try {
                MultipartFile mpf = (MultipartFile)value;
                this.writeByteArray(output, writer, name, mpf.getOriginalFilename(), mpf.getContentType(), mpf.getBytes());
            }
            catch (IOException e) {
                throw new EncodeException("Can't encode MultipartFile", (Throwable)e);
            }
            return;
        }
        super.writeByteOrFile(output, writer, name, value);
    }
}

