/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodMetadata;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.vertx.VertxHttpClient;
import io.vertx.core.Future;
import io.vertx.core.VertxException;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

final class VertxMethodHandler
implements InvocationHandlerFactory.MethodHandler {
    private static final long MAX_RESPONSE_BUFFER_SIZE = 8192L;
    private final MethodMetadata metadata;
    private final Target<?> target;
    private final VertxHttpClient client;
    private final Retryer retryer;
    private final List<RequestInterceptor> requestInterceptors;
    private final Logger logger;
    private final Logger.Level logLevel;
    private final RequestTemplate.Factory buildTemplateFromArgs;
    private final Decoder decoder;
    private final ErrorDecoder errorDecoder;
    private final boolean decode404;

    private VertxMethodHandler(Target<?> target, VertxHttpClient client, Retryer retryer, List<RequestInterceptor> requestInterceptors, Logger logger, Logger.Level logLevel, MethodMetadata metadata, RequestTemplate.Factory buildTemplateFromArgs, Decoder decoder, ErrorDecoder errorDecoder, boolean decode404) {
        this.target = target;
        this.client = client;
        this.retryer = retryer;
        this.requestInterceptors = requestInterceptors;
        this.logger = logger;
        this.logLevel = logLevel;
        this.metadata = metadata;
        this.buildTemplateFromArgs = buildTemplateFromArgs;
        this.errorDecoder = errorDecoder;
        this.decoder = decoder;
        this.decode404 = decode404;
    }

    public Future invoke(Object[] argv) {
        RequestTemplate template = this.buildTemplateFromArgs.create(argv);
        Retryer retryer = this.retryer.clone();
        RetryRecoverer recoverer = new RetryRecoverer(template, retryer);
        return this.executeAndDecode(template).recover(recoverer);
    }

    private Future<Object> executeAndDecode(RequestTemplate template) {
        Request request = this.targetRequest(template);
        this.logRequest(request);
        Instant start = Instant.now();
        return this.client.execute(request).compose(response -> {
            long elapsedTime = Duration.between(start, Instant.now()).toMillis();
            boolean shouldClose = true;
            try {
                if (this.logLevel != Logger.Level.NONE) {
                    response = this.logger.logAndRebufferResponse(this.metadata.configKey(), this.logLevel, response, elapsedTime);
                }
                if (Response.class == this.metadata.returnType()) {
                    if (response.body() == null) {
                        Future future = Future.succeededFuture((Object)response);
                        return future;
                    }
                    if (response.body().length() == null || (long)response.body().length().intValue() > 8192L) {
                        shouldClose = false;
                        Future future = Future.succeededFuture((Object)response);
                        return future;
                    }
                    Future future = Future.succeededFuture((Object)Response.builder().status(response.status()).reason(response.reason()).headers(response.headers()).request(response.request()).body(response.body()).build());
                    return future;
                }
                if (response.status() >= 200 && response.status() < 300) {
                    if (Void.class == this.metadata.returnType()) {
                        Future future = Future.succeededFuture();
                        return future;
                    }
                    Future future = Future.succeededFuture((Object)this.decode((Response)response, request));
                    return future;
                }
                if (this.decode404 && response.status() == 404) {
                    Future future = Future.succeededFuture((Object)this.decoder.decode(response, this.metadata.returnType()));
                    return future;
                }
                Future future = Future.failedFuture((Throwable)this.errorDecoder.decode(this.metadata.configKey(), response));
                return future;
            }
            catch (IOException ioException) {
                this.logIoException(ioException, elapsedTime);
                Future future = Future.failedFuture((Throwable)FeignException.errorReading((Request)request, (Response)response, (IOException)ioException));
                return future;
            }
            catch (FeignException exception) {
                Future future = Future.failedFuture((Throwable)exception);
                return future;
            }
            finally {
                if (shouldClose) {
                    Util.ensureClosed((Closeable)response.body());
                }
            }
        }, failure -> {
            if (failure instanceof VertxException || failure instanceof TimeoutException) {
                return Future.failedFuture((Throwable)failure);
            }
            if (failure.getCause() instanceof IOException) {
                long elapsedTime = Duration.between(start, Instant.now()).toMillis();
                this.logIoException((IOException)failure.getCause(), elapsedTime);
                return Future.failedFuture((Throwable)FeignException.errorExecuting((Request)request, (IOException)((IOException)failure.getCause())));
            }
            return Future.failedFuture((Throwable)failure.getCause());
        });
    }

    private Request targetRequest(RequestTemplate template) {
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.apply(template);
        }
        return this.target.apply(template);
    }

    private Object decode(Response response, Request request) throws IOException, FeignException {
        try {
            return this.decoder.decode(response, this.metadata.returnType());
        }
        catch (FeignException feignException) {
            throw feignException;
        }
        catch (RuntimeException unexpectedException) {
            throw new DecodeException(-1, unexpectedException.getMessage(), request, (Throwable)unexpectedException);
        }
    }

    private void logRequest(Request request) {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logRequest(this.metadata.configKey(), this.logLevel, request);
        }
    }

    private void logIoException(IOException exception, long elapsedTime) {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logIOException(this.metadata.configKey(), this.logLevel, exception, elapsedTime);
        }
    }

    private void logRetry() {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logRetry(this.metadata.configKey(), this.logLevel);
        }
    }

    private final class RetryRecoverer<T>
    implements Function<Throwable, Future<T>> {
        private final RequestTemplate template;
        private final Retryer retryer;

        private RetryRecoverer(RequestTemplate template, Retryer retryer) {
            this.template = template;
            this.retryer = retryer;
        }

        @Override
        public Future<T> apply(Throwable throwable) {
            if (throwable instanceof RetryableException) {
                this.retryer.continueOrPropagate((RetryableException)throwable);
                VertxMethodHandler.this.logRetry();
                return VertxMethodHandler.this.executeAndDecode(this.template).recover((Function)this);
            }
            return Future.failedFuture((Throwable)throwable);
        }
    }

    static final class Factory {
        private final VertxHttpClient client;
        private final Retryer retryer;
        private final List<RequestInterceptor> requestInterceptors;
        private final Logger logger;
        private final Logger.Level logLevel;
        private final boolean decode404;

        Factory(VertxHttpClient client, Retryer retryer, List<RequestInterceptor> requestInterceptors, Logger logger, Logger.Level logLevel, boolean decode404) {
            this.client = client;
            this.retryer = retryer;
            this.requestInterceptors = requestInterceptors;
            this.logger = logger;
            this.logLevel = logLevel;
            this.decode404 = decode404;
        }

        InvocationHandlerFactory.MethodHandler create(Target<?> target, MethodMetadata metadata, RequestTemplate.Factory buildTemplateFromArgs, Decoder decoder, ErrorDecoder errorDecoder) {
            return new VertxMethodHandler(target, this.client, this.retryer, this.requestInterceptors, this.logger, this.logLevel, metadata, buildTemplateFromArgs, decoder, errorDecoder, this.decode404);
        }
    }
}

