/*
 * Decompiled with CFR 0.152.
 */
package feign.vertx;

import feign.Request;
import feign.Response;
import feign.Util;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class VertxHttpClient {
    private final HttpClient httpClient;
    private final long timeout;
    private final UnaryOperator<HttpRequest<Buffer>> requestPreProcessor;

    public VertxHttpClient(Vertx vertx, HttpClientOptions options, long timeout, UnaryOperator<HttpRequest<Buffer>> requestPreProcessor) {
        Util.checkNotNull((Object)vertx, (String)"Argument vertx must not be null", (Object[])new Object[0]);
        Util.checkNotNull((Object)options, (String)"Argument options must be not null", (Object[])new Object[0]);
        Util.checkNotNull(requestPreProcessor, (String)"Argument requestPreProcessor must be not null", (Object[])new Object[0]);
        this.httpClient = vertx.createHttpClient(options);
        this.timeout = timeout;
        this.requestPreProcessor = requestPreProcessor;
    }

    public Future<Response> execute(Request request) {
        HttpRequest<Buffer> httpClientRequest;
        Util.checkNotNull((Object)request, (String)"Argument request must be not null", (Object[])new Object[0]);
        try {
            httpClientRequest = this.makeHttpClientRequest(request);
        }
        catch (MalformedURLException unexpectedException) {
            return Future.failedFuture((Throwable)unexpectedException);
        }
        Future responseFuture = request.body() != null ? httpClientRequest.sendBuffer(Buffer.buffer((byte[])request.body())) : httpClientRequest.send();
        return responseFuture.compose(response -> {
            Map<String, Collection> responseHeaders = StreamSupport.stream(response.headers().spliterator(), false).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toCollection(ArrayList::new))));
            byte[] body = response.body() != null ? ((Buffer)response.body()).getBytes() : null;
            return Future.succeededFuture((Object)Response.builder().status(response.statusCode()).reason(response.statusMessage()).headers(responseHeaders).body(body).request(request).build());
        });
    }

    private HttpRequest<Buffer> makeHttpClientRequest(Request request) throws MalformedURLException {
        URL url = new URL(request.url());
        String host = url.getHost();
        String requestUri = url.getFile();
        int port = url.getPort() > -1 ? url.getPort() : (url.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
        HttpRequest httpClientRequest = WebClient.wrap((HttpClient)this.httpClient).request(HttpMethod.valueOf((String)request.httpMethod().name()), port, host, requestUri).timeout(this.timeout);
        for (Map.Entry header : request.headers().entrySet()) {
            httpClientRequest = httpClientRequest.putHeader((String)header.getKey(), (Iterable)header.getValue());
        }
        return (HttpRequest)this.requestPreProcessor.apply(httpClientRequest);
    }
}

