/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsynchronousMethodHandler;
import feign.BuildTemplateByResolvingArgs;
import feign.Client;
import feign.Contract;
import feign.DefaultMethodHandler;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodMetadata;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.Util;
import feign.VertxInvocationHandler;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.vertx.VertxDelegatingContract;
import feign.vertx.VertxHttpClient;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VertxFeign
extends Feign {
    private final ParseHandlersByName targetToHandlersByName;
    private final InvocationHandlerFactory factory;

    private VertxFeign(ParseHandlersByName targetToHandlersByName, InvocationHandlerFactory factory) {
        this.targetToHandlersByName = targetToHandlersByName;
        this.factory = factory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T newInstance(Target<T> target) {
        Map<String, InvocationHandlerFactory.MethodHandler> nameToHandler = this.targetToHandlersByName.apply(target);
        LinkedHashMap<Method, Object> methodToHandler = new LinkedHashMap<Method, Object>();
        LinkedList<DefaultMethodHandler> defaultMethodHandlers = new LinkedList<DefaultMethodHandler>();
        for (Method method : target.type().getMethods()) {
            if (Util.isDefault((Method)method)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method, handler);
                continue;
            }
            methodToHandler.put(method, nameToHandler.get(Feign.configKey((Class)target.type(), (Method)method)));
        }
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    private static final class ParseHandlersByName {
        private final Contract contract;
        private final HttpClientOptions options;
        private final Encoder encoder;
        private final Decoder decoder;
        private final ErrorDecoder errorDecoder;
        private final AsynchronousMethodHandler.Factory factory;

        ParseHandlersByName(Contract contract, HttpClientOptions options, Encoder encoder, Decoder decoder, ErrorDecoder errorDecoder, AsynchronousMethodHandler.Factory factory) {
            this.contract = contract;
            this.options = options;
            this.factory = factory;
            this.errorDecoder = errorDecoder;
            this.encoder = (Encoder)Util.checkNotNull((Object)encoder, (String)"encoder must not be null", (Object[])new Object[0]);
            this.decoder = (Decoder)Util.checkNotNull((Object)decoder, (String)"decoder must not be null", (Object[])new Object[0]);
        }

        Map<String, InvocationHandlerFactory.MethodHandler> apply(Target key) {
            List metadata = this.contract.parseAndValidatateMetadata(key.type());
            LinkedHashMap<String, InvocationHandlerFactory.MethodHandler> result = new LinkedHashMap<String, InvocationHandlerFactory.MethodHandler>();
            for (MethodMetadata md : metadata) {
                BuildTemplateByResolvingArgs buildTemplate = !md.formParams().isEmpty() && md.template().bodyTemplate() == null ? new BuildTemplateByResolvingArgs.BuildFormEncodedTemplateFromArgs(md, this.encoder) : (md.bodyIndex() != null ? new BuildTemplateByResolvingArgs.BuildEncodedTemplateFromArgs(md, this.encoder) : new BuildTemplateByResolvingArgs(md));
                result.put(md.configKey(), this.factory.create(key, md, buildTemplate, this.options, this.decoder, this.errorDecoder));
            }
            return result;
        }
    }

    public static final class Builder
    extends Feign.Builder {
        private Vertx vertx;
        private final List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
        private Logger.Level logLevel = Logger.Level.NONE;
        private Contract contract = new VertxDelegatingContract((Contract)new Contract.Default());
        private VertxHttpClient client;
        private Retryer retryer = new Retryer.Default();
        private Logger logger = new Logger.NoOpLogger();
        private Encoder encoder = new Encoder.Default();
        private Decoder decoder = new Decoder.Default();
        private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
        private HttpClientOptions options = new HttpClientOptions();
        private InvocationHandlerFactory invocationHandlerFactory = new VertxInvocationHandler.Factory();
        private boolean decode404;

        public Builder client(Client client) {
            throw new UnsupportedOperationException();
        }

        public Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException();
        }

        public Builder vertx(Vertx vertx) {
            this.vertx = vertx;
            this.client = new VertxHttpClient(vertx);
            return this;
        }

        public Builder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder contract(Contract contract) {
            this.contract = new VertxDelegatingContract(contract);
            return this;
        }

        public Builder retryer(Retryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder encoder(Encoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder decoder(Decoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder decode404() {
            this.decode404 = true;
            return this;
        }

        public Builder errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
            return this;
        }

        public Builder options(HttpClientOptions options) {
            this.options = options;
            return this;
        }

        public Builder options(Request.Options options) {
            this.options = new HttpClientOptions().setConnectTimeout(options.connectTimeoutMillis()).setIdleTimeout(options.readTimeoutMillis());
            return this;
        }

        public Builder requestInterceptor(RequestInterceptor requestInterceptor) {
            this.requestInterceptors.add(requestInterceptor);
            return this;
        }

        public Builder requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            this.requestInterceptors.clear();
            for (RequestInterceptor requestInterceptor : requestInterceptors) {
                this.requestInterceptors.add(requestInterceptor);
            }
            return this;
        }

        public <T> T target(Class<T> apiType, String url) {
            return this.target((Target<T>)new Target.HardCodedTarget(apiType, url));
        }

        public <T> T target(Target<T> target) {
            return this.build().newInstance(target);
        }

        public VertxFeign build() {
            Util.checkNotNull((Object)this.vertx, (String)"Vertx instance wasn't provided in VertxFeign builder", (Object[])new Object[0]);
            AsynchronousMethodHandler.Factory methodHandlerFactory = new AsynchronousMethodHandler.Factory(this.client, this.retryer, this.requestInterceptors, this.logger, this.logLevel, this.decode404);
            ParseHandlersByName handlersByName = new ParseHandlersByName(this.contract, this.options, this.encoder, this.decoder, this.errorDecoder, methodHandlerFactory);
            return new VertxFeign(handlersByName, this.invocationHandlerFactory);
        }
    }
}

