/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodMetadata;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.vertx.VertxHttpClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;

class AsynchronousMethodHandler
implements InvocationHandlerFactory.MethodHandler {
    private static final long MAX_RESPONSE_BUFFER_SIZE = 8192L;
    private final MethodMetadata metadata;
    private final Target<?> target;
    private final VertxHttpClient client;
    private final Retryer retryer;
    private final List<RequestInterceptor> requestInterceptors;
    private final Logger logger;
    private final Logger.Level logLevel;
    private final RequestTemplate.Factory buildTemplateFromArgs;
    private final Request.Options options;
    private final Decoder decoder;
    private final ErrorDecoder errorDecoder;
    private final boolean decode404;

    private AsynchronousMethodHandler(Target<?> target, VertxHttpClient client, Retryer retryer, List<RequestInterceptor> requestInterceptors, Logger logger, Logger.Level logLevel, MethodMetadata metadata, RequestTemplate.Factory buildTemplateFromArgs, Request.Options options, Decoder decoder, ErrorDecoder errorDecoder, boolean decode404) {
        this.target = (Target)Util.checkNotNull(target, (String)"target must be not null", (Object[])new Object[0]);
        this.client = (VertxHttpClient)Util.checkNotNull((Object)client, (String)"client must be not null", (Object[])new Object[0]);
        this.retryer = (Retryer)Util.checkNotNull((Object)retryer, (String)"retryer for %s must be not null", (Object[])new Object[]{target});
        this.requestInterceptors = (List)Util.checkNotNull(requestInterceptors, (String)"requestInterceptors for %s must be not null", (Object[])new Object[]{target});
        this.logger = (Logger)Util.checkNotNull((Object)logger, (String)"logger for %s must be not null", (Object[])new Object[]{target});
        this.logLevel = (Logger.Level)Util.checkNotNull((Object)logLevel, (String)"logLevel for %s must be not null", (Object[])new Object[]{target});
        this.metadata = (MethodMetadata)Util.checkNotNull((Object)metadata, (String)"metadata for %s must be not null", (Object[])new Object[]{target});
        this.buildTemplateFromArgs = (RequestTemplate.Factory)Util.checkNotNull((Object)buildTemplateFromArgs, (String)"metadata for %s must be not null", (Object[])new Object[]{target});
        this.options = (Request.Options)Util.checkNotNull((Object)options, (String)"options for %s must be not null", (Object[])new Object[]{target});
        this.errorDecoder = (ErrorDecoder)Util.checkNotNull((Object)errorDecoder, (String)"errorDecoder for %s must be not null", (Object[])new Object[]{target});
        this.decoder = (Decoder)Util.checkNotNull((Object)decoder, (String)"decoder for %s must be not null", (Object[])new Object[]{target});
        this.decode404 = decode404;
    }

    public Future invoke(Object[] argv) throws Throwable {
        RequestTemplate template = this.buildTemplateFromArgs.create(argv);
        Retryer retryer = this.retryer.clone();
        ResultHandlerWithRetryer handler = new ResultHandlerWithRetryer(template, retryer);
        this.executeAndDecode(template).setHandler(handler);
        return handler.getResultFuture();
    }

    private Future<Object> executeAndDecode(RequestTemplate template) {
        Request request = this.targetRequest(template);
        Future decodedResultFuture = Future.future();
        this.logRequest(request);
        Instant start = Instant.now();
        this.client.execute(request, this.options).setHandler(res -> {
            boolean shouldClose = true;
            long elapsedTime = Duration.between(start, Instant.now()).toMillis();
            if (res.succeeded()) {
                Response response = (Response)res.result();
                try {
                    if (this.logLevel != Logger.Level.NONE) {
                        response = this.logger.logAndRebufferResponse(this.metadata.configKey(), this.logLevel, response, elapsedTime);
                    }
                    if (Response.class == this.metadata.returnType()) {
                        if (response.body() == null) {
                            decodedResultFuture.complete((Object)response);
                        }
                        if (response.body().length() == null || (long)response.body().length().intValue() > 8192L) {
                            shouldClose = false;
                            decodedResultFuture.complete((Object)response);
                        }
                        byte[] bodyData = Util.toByteArray((InputStream)response.body().asInputStream());
                        decodedResultFuture.complete((Object)Response.create((int)response.status(), (String)response.reason(), (Map)response.headers(), (byte[])bodyData));
                    }
                    if (response.status() >= 200 && response.status() < 300) {
                        if (Void.class == this.metadata.returnType()) {
                            decodedResultFuture.complete();
                        }
                        decodedResultFuture.complete(this.decode(response));
                    }
                    if (this.decode404 && response.status() == 404) {
                        decodedResultFuture.complete(this.decoder.decode(response, this.metadata.returnType()));
                    }
                    decodedResultFuture.fail((Throwable)this.errorDecoder.decode(this.metadata.configKey(), response));
                }
                catch (IOException ioException) {
                    this.logIoException(ioException, elapsedTime);
                    decodedResultFuture.fail((Throwable)FeignException.errorReading((Request)request, (Response)response, (IOException)ioException));
                }
                catch (FeignException exception) {
                    decodedResultFuture.fail((Throwable)exception);
                }
                finally {
                    if (shouldClose) {
                        Util.ensureClosed((Closeable)response.body());
                    }
                }
            } else if (res.cause() instanceof IOException) {
                this.logIoException((IOException)res.cause(), elapsedTime);
                decodedResultFuture.fail((Throwable)FeignException.errorExecuting((Request)request, (IOException)((IOException)res.cause())));
            } else {
                decodedResultFuture.fail(res.cause());
            }
        });
        return decodedResultFuture;
    }

    private Request targetRequest(RequestTemplate template) {
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.apply(template);
        }
        return this.target.apply(new RequestTemplate(template));
    }

    private Object decode(Response response) throws IOException, FeignException {
        try {
            return this.decoder.decode(response, this.metadata.returnType());
        }
        catch (FeignException feignException) {
            throw feignException;
        }
        catch (RuntimeException unexpectedException) {
            throw new DecodeException(unexpectedException.getMessage(), (Throwable)unexpectedException);
        }
    }

    private void logRequest(Request request) {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logRequest(this.metadata.configKey(), this.logLevel, request);
        }
    }

    private void logIoException(IOException exception, long elapsedTime) {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logIOException(this.metadata.configKey(), this.logLevel, exception, elapsedTime);
        }
    }

    private void logRetry() {
        if (this.logLevel != Logger.Level.NONE) {
            this.logger.logRetry(this.metadata.configKey(), this.logLevel);
        }
    }

    private class ResultHandlerWithRetryer<T>
    implements Handler<AsyncResult<T>> {
        private final RequestTemplate template;
        private final Retryer retryer;
        private final Future<T> resultFuture = Future.future();

        private ResultHandlerWithRetryer(RequestTemplate template, Retryer retryer) {
            this.template = template;
            this.retryer = retryer;
        }

        public void handle(AsyncResult<T> result) {
            if (result.succeeded()) {
                this.resultFuture.complete(result.result());
            } else {
                try {
                    throw result.cause();
                }
                catch (RetryableException retryableException) {
                    try {
                        this.retryer.continueOrPropagate(retryableException);
                        AsynchronousMethodHandler.this.logRetry();
                        AsynchronousMethodHandler.this.executeAndDecode(this.template).setHandler((Handler)this);
                    }
                    catch (RetryableException noMoreRetryAttempts) {
                        this.resultFuture.fail((Throwable)noMoreRetryAttempts);
                    }
                }
                catch (Throwable otherException) {
                    this.resultFuture.fail(otherException);
                }
            }
        }

        private Future<?> getResultFuture() {
            return this.resultFuture;
        }
    }

    static class Factory {
        private final VertxHttpClient client;
        private final Retryer retryer;
        private final List<RequestInterceptor> requestInterceptors;
        private final Logger logger;
        private final Logger.Level logLevel;
        private final boolean decode404;

        Factory(VertxHttpClient client, Retryer retryer, List<RequestInterceptor> requestInterceptors, Logger logger, Logger.Level logLevel, boolean decode404) {
            this.client = (VertxHttpClient)Util.checkNotNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
            this.retryer = (Retryer)Util.checkNotNull((Object)retryer, (String)"retryer must not be null", (Object[])new Object[0]);
            this.requestInterceptors = (List)Util.checkNotNull(requestInterceptors, (String)"requestInterceptors must not be null", (Object[])new Object[0]);
            this.logger = (Logger)Util.checkNotNull((Object)logger, (String)"logger must not be null", (Object[])new Object[0]);
            this.logLevel = (Logger.Level)Util.checkNotNull((Object)logLevel, (String)"logLevel must not be null", (Object[])new Object[0]);
            this.decode404 = decode404;
        }

        InvocationHandlerFactory.MethodHandler create(Target<?> target, MethodMetadata metadata, RequestTemplate.Factory buildTemplateFromArgs, Request.Options options, Decoder decoder, ErrorDecoder errorDecoder) {
            return new AsynchronousMethodHandler(target, this.client, this.retryer, this.requestInterceptors, this.logger, this.logLevel, metadata, buildTemplateFromArgs, options, decoder, errorDecoder, this.decode404);
        }
    }
}

