/*
 * Decompiled with CFR 0.152.
 */
package feign.soap;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.jaxb.JAXBContextFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SOAPEncoder
implements Encoder {
    private static final String DEFAULT_SOAP_PROTOCOL = "SOAP 1.1 Protocol";
    private final boolean writeXmlDeclaration;
    private final boolean formattedOutput;
    private final Charset charsetEncoding;
    private final JAXBContextFactory jaxbContextFactory;
    private final String soapProtocol;

    private SOAPEncoder(Builder builder) {
        this.jaxbContextFactory = builder.jaxbContextFactory;
        this.writeXmlDeclaration = builder.writeXmlDeclaration;
        this.charsetEncoding = builder.charsetEncoding;
        this.soapProtocol = builder.soapProtocol;
        this.formattedOutput = builder.formattedOutput;
    }

    public SOAPEncoder(JAXBContextFactory jaxbContextFactory) {
        this.jaxbContextFactory = jaxbContextFactory;
        this.writeXmlDeclaration = true;
        this.formattedOutput = false;
        this.charsetEncoding = Charset.defaultCharset();
        this.soapProtocol = DEFAULT_SOAP_PROTOCOL;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        if (!(bodyType instanceof Class)) {
            throw new UnsupportedOperationException("SOAP only supports encoding raw types. Found " + bodyType);
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller marshaller = this.jaxbContextFactory.createMarshaller((Class)bodyType);
            marshaller.marshal(object, (Node)document);
            SOAPMessage soapMessage = MessageFactory.newInstance((String)this.soapProtocol).createMessage();
            soapMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)Boolean.toString(this.writeXmlDeclaration));
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charsetEncoding.displayName());
            soapMessage.getSOAPBody().addDocument(document);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.formattedOutput) {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource((Node)soapMessage.getSOAPPart()), new StreamResult(bos));
            } else {
                soapMessage.writeTo((OutputStream)bos);
            }
            template.body(new String(bos.toByteArray()));
        }
        catch (IOException | JAXBException | ParserConfigurationException | SOAPException | TransformerException | TransformerFactoryConfigurationError e) {
            throw new EncodeException(e.toString(), e);
        }
    }

    public static class Builder {
        private JAXBContextFactory jaxbContextFactory;
        public boolean formattedOutput = false;
        private boolean writeXmlDeclaration = true;
        private Charset charsetEncoding = Charset.defaultCharset();
        private String soapProtocol = "SOAP 1.1 Protocol";

        public Builder withJAXBContextFactory(JAXBContextFactory jaxbContextFactory) {
            this.jaxbContextFactory = jaxbContextFactory;
            return this;
        }

        public Builder withFormattedOutput(boolean formattedOutput) {
            this.formattedOutput = formattedOutput;
            return this;
        }

        public Builder withWriteXmlDeclaration(boolean writeXmlDeclaration) {
            this.writeXmlDeclaration = writeXmlDeclaration;
            return this;
        }

        public Builder withCharsetEncoding(Charset charsetEncoding) {
            this.charsetEncoding = charsetEncoding;
            return this;
        }

        public Builder withSOAPProtocol(String soapProtocol) {
            this.soapProtocol = soapProtocol;
            return this;
        }

        public SOAPEncoder build() {
            if (this.jaxbContextFactory == null) {
                throw new IllegalStateException("JAXBContextFactory must be non-null");
            }
            return new SOAPEncoder(this);
        }
    }
}

