/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

public final class LBClient
extends AbstractLoadBalancerAwareClient<RibbonRequest, RibbonResponse> {
    private final int connectTimeout;
    private final int readTimeout;
    private final IClientConfig clientConfig;

    public static LBClient create(ILoadBalancer lb, IClientConfig clientConfig) {
        return new LBClient(lb, clientConfig);
    }

    LBClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
        this.clientConfig = clientConfig;
        this.connectTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ConnectTimeout);
        this.readTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ReadTimeout);
    }

    public RibbonResponse execute(RibbonRequest request, IClientConfig configOverride) throws IOException {
        Request.Options options = configOverride != null ? new Request.Options(((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), ((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue()) : new Request.Options(this.connectTimeout, this.readTimeout);
        Response response = request.client().execute(request.toRequest(), options);
        return new RibbonResponse(request.getUri(), response);
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonRequest request, IClientConfig requestConfig) {
        if (((Boolean)this.clientConfig.get(CommonClientConfigKey.OkToRetryOnAllOperations, (Object)false)).booleanValue()) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!request.toRequest().method().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    static class RibbonResponse
    implements IResponse {
        private final URI uri;
        private final Response response;

        RibbonResponse(URI uri, Response response) {
            this.uri = uri;
            this.response = response;
        }

        public Object getPayload() throws ClientException {
            return this.response.body();
        }

        public boolean hasPayload() {
            return this.response.body() != null;
        }

        public boolean isSuccess() {
            return this.response.status() == 200;
        }

        public URI getRequestedURI() {
            return this.uri;
        }

        public Map<String, Collection<String>> getHeaders() {
            return this.response.headers();
        }

        Response toResponse() {
            return this.response;
        }

        public void close() throws IOException {
            if (this.response != null && this.response.body() != null) {
                this.response.body().close();
            }
        }
    }

    static class RibbonRequest
    extends ClientRequest
    implements Cloneable {
        private final Request request;
        private final Client client;

        RibbonRequest(Client client, Request request, URI uri) {
            this.client = client;
            this.request = request;
            this.setUri(uri);
        }

        Request toRequest() {
            return new RequestTemplate().method(this.request.method()).append((CharSequence)this.getUri().toASCIIString()).headers(this.request.headers()).body(this.request.body(), this.request.charset()).request();
        }

        Client client() {
            return this.client;
        }

        public Object clone() {
            return new RibbonRequest(this.client, this.request, this.getUri());
        }
    }
}

