/*
 * Decompiled with CFR 0.152.
 */
package feign.reactive;

import feign.FeignException;
import feign.Response;
import feign.Types;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorDecoder
implements Decoder {
    private final Decoder delegate;

    public ReactorDecoder(Decoder decoder) {
        this.delegate = decoder;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        Class rawType = Types.getRawType((Type)type);
        if (rawType.isAssignableFrom(Mono.class)) {
            Type lastType = Types.resolveLastTypeParameter((Type)type, Mono.class);
            return this.delegate.decode(response, lastType);
        }
        if (rawType.isAssignableFrom(Flux.class)) {
            Type lastType = Types.resolveLastTypeParameter((Type)type, Flux.class);
            ParameterizedType listType = Types.parameterize(List.class, (Type[])new Type[]{lastType});
            return this.delegate.decode(response, (Type)listType);
        }
        return this.delegate.decode(response, type);
    }
}

