/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.micrometer.FeignMetricName;
import feign.micrometer.MeteredBody;
import feign.micrometer.MetricName;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

public class MeteredDecoder
implements Decoder {
    private final Decoder decoder;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;

    public MeteredDecoder(Decoder decoder, MeterRegistry meterRegistry) {
        this(decoder, meterRegistry, new FeignMetricName(Decoder.class));
    }

    public MeteredDecoder(Decoder decoder, MeterRegistry meterRegistry, MetricName metricName) {
        this.decoder = decoder;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        Object decoded;
        RequestTemplate template = response.request().requestTemplate();
        Optional<MeteredBody> body = Optional.ofNullable(response.body()).map(MeteredBody::new);
        Response meteredResponse = body.map(b -> response.toBuilder().body((Response.Body)b).build()).orElse(response);
        try {
            decoded = this.meterRegistry.timer(this.metricName.name(), (Iterable)this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).recordCallable(() -> this.decoder.decode(meteredResponse, type));
        }
        catch (IOException | RuntimeException e) {
            this.meterRegistry.counter(this.metricName.name("error_count"), (Iterable)this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0]).and(new Tag[]{Tag.of((String)"exception_name", (String)e.getClass().getSimpleName())})).count();
            throw e;
        }
        catch (Exception e) {
            this.meterRegistry.counter(this.metricName.name("error_count"), (Iterable)this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0]).and(new Tag[]{Tag.of((String)"exception_name", (String)e.getClass().getSimpleName())})).count();
            throw new IOException(e);
        }
        body.ifPresent(b -> this.meterRegistry.summary(this.metricName.name("response_size"), (Iterable)this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).record((double)b.count()));
        return decoded;
    }
}

