/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson.jr;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.JacksonJrExtension;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jackson.jr.JacksonJrMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JacksonJrDecoder
extends JacksonJrMapper
implements Decoder {
    public JacksonJrDecoder() {
    }

    public JacksonJrDecoder(JSON mapper) {
        super(mapper);
    }

    public JacksonJrDecoder(Iterable<JacksonJrExtension> iterable) {
        super(iterable);
    }

    public Object decode(Response response, Type type) throws IOException {
        Transformer transformer = JacksonJrDecoder.findTransformer(response, type);
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(response.charset());
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return null;
            }
            reader.reset();
            return transformer.apply(this.mapper, reader);
        }
        catch (JSONObjectException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private static Transformer findTransformer(Response response, Type type) {
        if (type instanceof Class) {
            return (mapper, reader) -> mapper.beanFrom((Class)type, (Object)reader);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            Type[] parameterType = ((ParameterizedType)type).getActualTypeArguments();
            if (rawType.equals(List.class)) {
                return (mapper, reader) -> mapper.listOfFrom((Class)parameterType[0], (Object)reader);
            }
            if (rawType.equals(Map.class)) {
                return (mapper, reader) -> mapper.mapOfFrom((Class)parameterType[1], (Object)reader);
            }
        }
        throw new DecodeException(500, "Cannot decode type: " + type.getTypeName(), response.request());
    }

    @FunctionalInterface
    static interface Transformer {
        public Object apply(JSON var1, Reader var2) throws IOException;
    }
}

