/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson.jaxb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.core.MediaType;

public final class JacksonJaxbJsonEncoder
implements Encoder {
    private final JacksonJaxbJsonProvider jacksonJaxbJsonProvider;

    public JacksonJaxbJsonEncoder() {
        this.jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider();
    }

    public JacksonJaxbJsonEncoder(ObjectMapper objectMapper) {
        this.jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider(objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.jacksonJaxbJsonProvider.writeTo(object, bodyType.getClass(), null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)outputStream);
            template.body(outputStream.toByteArray(), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), (Throwable)e);
        }
    }
}

