/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import feign.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface FallbackFactory<T> {
    public T create(Throwable var1);

    public static final class Default<T>
    implements FallbackFactory<T> {
        final Logger logger;
        final T constant;

        public Default(T constant) {
            this(constant, Logger.getLogger(Default.class.getName()));
        }

        Default(T constant, Logger logger) {
            this.constant = Util.checkNotNull(constant, (String)"fallback", (Object[])new Object[0]);
            this.logger = (Logger)Util.checkNotNull((Object)logger, (String)"logger", (Object[])new Object[0]);
        }

        @Override
        public T create(Throwable cause) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "fallback due to: " + cause.getMessage(), cause);
            }
            return this.constant;
        }

        public String toString() {
            return this.constant.toString();
        }
    }
}

