/*
 * Decompiled with CFR 0.152.
 */
package feign.optionals;

import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

public final class OptionalDecoder
implements Decoder {
    final Decoder delegate;

    public OptionalDecoder(Decoder delegate) {
        Objects.requireNonNull(delegate, "Decoder must not be null. ");
        this.delegate = delegate;
    }

    @Override
    public Object decode(Response response, Type type2) throws IOException {
        if (!OptionalDecoder.isOptional(type2)) {
            return this.delegate.decode(response, type2);
        }
        if (response.status() == 404 || response.status() == 204) {
            return Optional.empty();
        }
        Type enclosedType = Util.resolveLastTypeParameter(type2, Optional.class);
        return Optional.ofNullable(this.delegate.decode(response, enclosedType));
    }

    static boolean isOptional(Type type2) {
        if (!(type2 instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type2;
        return parameterizedType.getRawType().equals(Optional.class);
    }
}

