/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.lang.reflect.Type;

public class InvocationContext {
    private static final long MAX_RESPONSE_BUFFER_SIZE = 8192L;
    private final String configKey;
    private final Decoder decoder;
    private final ErrorDecoder errorDecoder;
    private final boolean dismiss404;
    private final boolean closeAfterDecode;
    private final boolean decodeVoid;
    private final Response response;
    private final Type returnType;

    InvocationContext(String configKey, Decoder decoder, ErrorDecoder errorDecoder, boolean dismiss404, boolean closeAfterDecode, boolean decodeVoid, Response response, Type returnType) {
        this.configKey = configKey;
        this.decoder = decoder;
        this.errorDecoder = errorDecoder;
        this.dismiss404 = dismiss404;
        this.closeAfterDecode = closeAfterDecode;
        this.decodeVoid = decodeVoid;
        this.response = response;
        this.returnType = returnType;
    }

    public Decoder decoder() {
        return this.decoder;
    }

    public Type returnType() {
        return this.returnType;
    }

    public Response response() {
        return this.response;
    }

    public Object proceed() throws Exception {
        if (this.returnType == Response.class) {
            return InvocationContext.disconnectResponseBodyIfNeeded(this.response);
        }
        try {
            boolean shouldDecodeResponseBody;
            boolean bl = shouldDecodeResponseBody = this.response.status() >= 200 && this.response.status() < 300 || this.response.status() == 404 && this.dismiss404 && !this.isVoidType(this.returnType);
            if (!shouldDecodeResponseBody) {
                throw this.decodeError(this.configKey, this.response);
            }
            if (this.isVoidType(this.returnType) && !this.decodeVoid) {
                Util.ensureClosed(this.response.body());
                Object var2_2 = null;
                return var2_2;
            }
            Object object = this.decoder.decode(this.response, this.returnType);
            return object;
        }
        finally {
            if (this.closeAfterDecode) {
                Util.ensureClosed(this.response.body());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response disconnectResponseBodyIfNeeded(Response response) throws IOException {
        boolean shouldDisconnectResponseBody;
        boolean bl = shouldDisconnectResponseBody = response.body() != null && response.body().length() != null && (long)response.body().length().intValue() <= 8192L;
        if (!shouldDisconnectResponseBody) {
            return response;
        }
        try {
            byte[] bodyData = Util.toByteArray(response.body().asInputStream());
            Response response2 = response.toBuilder().body(bodyData).build();
            return response2;
        }
        finally {
            Util.ensureClosed(response.body());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception decodeError(String methodKey, Response response) {
        try {
            Exception exception = this.errorDecoder.decode(methodKey, response);
            return exception;
        }
        finally {
            Util.ensureClosed(response.body());
        }
    }

    private boolean isVoidType(Type returnType) {
        return returnType == Void.class || returnType == Void.TYPE || returnType.getTypeName().equals("kotlin.Unit");
    }
}

