/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.RequestTemplate;
import feign.Util;

public interface Target<T> {
    public Class<T> type();

    public String name();

    public String url();

    public Request apply(RequestTemplate var1);

    public static final class EmptyTarget<T>
    implements Target<T> {
        private final Class<T> type;
        private final String name;

        EmptyTarget(Class<T> type2, String name) {
            this.type = Util.checkNotNull(type2, "type", new Object[0]);
            this.name = Util.checkNotNull(Util.emptyToNull(name), "name", new Object[0]);
        }

        public static <T> EmptyTarget<T> create(Class<T> type2) {
            return new EmptyTarget<T>(type2, "empty:" + type2.getSimpleName());
        }

        public static <T> EmptyTarget<T> create(Class<T> type2, String name) {
            return new EmptyTarget<T>(type2, name);
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException("Empty targets don't have URLs");
        }

        @Override
        public Request apply(RequestTemplate input) {
            if (input.url().indexOf("http") != 0) {
                throw new UnsupportedOperationException("Request with non-absolute URL not supported with empty target");
            }
            return input.request();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EmptyTarget) {
                EmptyTarget other = (EmptyTarget)obj;
                return this.type.equals(other.type) && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.type.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            return result2;
        }

        public String toString() {
            if (this.name.equals("empty:" + this.type.getSimpleName())) {
                return "EmptyTarget(type=" + this.type.getSimpleName() + ")";
            }
            return "EmptyTarget(type=" + this.type.getSimpleName() + ", name=" + this.name + ")";
        }
    }

    public static class HardCodedTarget<T>
    implements Target<T> {
        private final Class<T> type;
        private final String name;
        private final String url;

        public HardCodedTarget(Class<T> type2, String url) {
            this(type2, url, url);
        }

        public HardCodedTarget(Class<T> type2, String name, String url) {
            this.type = Util.checkNotNull(type2, "type", new Object[0]);
            this.name = Util.checkNotNull(Util.emptyToNull(name), "name", new Object[0]);
            this.url = Util.checkNotNull(Util.emptyToNull(url), "url", new Object[0]);
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public Request apply(RequestTemplate input) {
            if (input.url().indexOf("http") != 0) {
                input.target(this.url());
            }
            return input.request();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HardCodedTarget) {
                HardCodedTarget other = (HardCodedTarget)obj;
                return this.type.equals(other.type) && this.name.equals(other.name) && this.url.equals(other.url);
            }
            return false;
        }

        public int hashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.type.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.url.hashCode();
            return result2;
        }

        public String toString() {
            if (this.name.equals(this.url)) {
                return "HardCodedTarget(type=" + this.type.getSimpleName() + ", url=" + this.url + ")";
            }
            return "HardCodedTarget(type=" + this.type.getSimpleName() + ", name=" + this.name + ", url=" + this.url + ")";
        }
    }
}

