/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoEnumFlags;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.SuspendFunctionTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializerKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotations;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionForAbsentTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributeTranslator;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    @NotNull
    private final DeserializationContext c;
    @Nullable
    private final TypeDeserializer parent;
    @NotNull
    private final String debugName;
    @NotNull
    private final String containerPresentableName;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> classifierDescriptors;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    @NotNull
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName, @NotNull String containerPresentableName) {
        Map map2;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        Intrinsics.checkNotNullParameter(containerPresentableName, "containerPresentableName");
        this.c = c;
        this.parent = parent;
        this.debugName = debugName;
        this.containerPresentableName = containerPresentableName;
        this.classifierDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassifierDescriptor(this.this$0, fqNameIndex);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            Iterator<ProtoBuf.TypeParameter> iterator2 = typeParameterProtos.iterator();
            int n = 0;
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            while (iterator2.hasNext()) {
                int index = n++;
                ProtoBuf.TypeParameter proto = iterator2.next();
                ((Map)result2).put(proto.getId(), new DeserializedTypeParameterDescriptor(this.c, proto, index));
            }
            typeDeserializer = typeDeserializer2;
            map2 = result2;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = TypeDeserializer.simpleType$default(this, proto, false, 2, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            Intrinsics.checkNotNull(type2);
            SimpleType upperBound = TypeDeserializer.simpleType$default(this, type2, false, 2, null);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(proto, id, lowerBound, upperBound);
        }
        return this.simpleType(proto, true);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeAttributes toAttributes(List<? extends TypeAttributeTranslator> $this$toAttributes, Annotations annotations2, TypeConstructor constructor, DeclarationDescriptor containingDeclaration) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAttributes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void translator;
            TypeAttributeTranslator typeAttributeTranslator = (TypeAttributeTranslator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(translator.toAttributes(annotations2, constructor, containingDeclaration));
        }
        List translated = CollectionsKt.flatten((List)destination$iv$iv);
        return TypeAttributes.Companion.create(translated);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, boolean expandTypeAliases) {
        Object computedType;
        block16: {
            Object object;
            SimpleType simpleType2;
            block15: {
                SimpleType simpleType3;
                void $this$mapIndexedTo$iv$iv;
                SimpleType localClassifierType;
                Intrinsics.checkNotNullParameter(proto, "proto");
                SimpleType simpleType4 = localClassifierType = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
                if (simpleType4 != null) {
                    return simpleType4;
                }
                TypeConstructor constructor = this.typeConstructor(proto);
                if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
                    String[] stringArray = new String[]{constructor.toString()};
                    return ErrorUtils.INSTANCE.createErrorType(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, constructor, stringArray);
                }
                DeserializedAnnotations annotations2 = new DeserializedAnnotations(this.c.getStorageManager(), (Function0<? extends List<? extends AnnotationDescriptor>>)new Function0<List<? extends AnnotationDescriptor>>(this, proto){
                    final /* synthetic */ TypeDeserializer this$0;
                    final /* synthetic */ ProtoBuf.Type $proto;
                    {
                        this.this$0 = $receiver;
                        this.$proto = $proto;
                        super(0);
                    }

                    @NotNull
                    public final List<AnnotationDescriptor> invoke() {
                        return TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
                    }
                });
                TypeAttributes attributes = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), annotations2, constructor, this.c.getContainingDeclaration());
                Iterable $this$mapIndexed$iv = TypeDeserializer.simpleType$collectAllArguments(proto, this);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void argumentProto;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<TypeParameterDescriptor> list = constructor.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list, "constructor.parameters");
                    collection.add(this.typeArgument(CollectionsKt.getOrNull(list, (int)index), (ProtoBuf.Type.Argument)argumentProto));
                }
                List arguments2 = CollectionsKt.toList((List)destination$iv$iv);
                ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
                if (expandTypeAliases && declarationDescriptor instanceof TypeAliasDescriptor) {
                    KotlinTypeFactory $this$simpleType_u24lambda_u242 = KotlinTypeFactory.INSTANCE;
                    boolean bl = false;
                    SimpleType expandedType = KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)declarationDescriptor, arguments2);
                    TypeAttributes expandedAttributes = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Iterable)expandedType.getAnnotations())), constructor, this.c.getContainingDeclaration());
                    simpleType3 = expandedType.makeNullableAsSpecified(KotlinTypeKt.isNullable(expandedType) || proto.getNullable()).replaceAttributes(expandedAttributes);
                } else {
                    Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
                    Intrinsics.checkNotNullExpressionValue(bl, "SUSPEND_TYPE.get(proto.flags)");
                    if (bl.booleanValue()) {
                        simpleType3 = this.createSuspendFunctionType(attributes, constructor, arguments2, proto.getNullable());
                    } else {
                        SimpleType it = KotlinTypeFactory.simpleType$default(attributes, constructor, arguments2, proto.getNullable(), null, 16, null);
                        boolean bl2 = false;
                        Boolean bl3 = Flags.DEFINITELY_NOT_NULL_TYPE.get(proto.getFlags());
                        Intrinsics.checkNotNullExpressionValue(bl3, "DEFINITELY_NOT_NULL_TYPE.get(proto.flags)");
                        if (bl3.booleanValue()) {
                            DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, it, false, 2, null);
                            if (definitelyNotNullType == null) {
                                throw new IllegalStateException(("null DefinitelyNotNullType for '" + it + '\'').toString());
                            }
                            simpleType3 = definitelyNotNullType;
                        } else {
                            simpleType3 = it;
                        }
                    }
                }
                simpleType2 = simpleType3;
                object = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
                if (object == null) break block15;
                ProtoBuf.Type it = object;
                boolean bl = false;
                SimpleType simpleType5 = SpecialTypesKt.withAbbreviation(simpleType2, this.simpleType(it, false));
                object = simpleType5;
                if (simpleType5 != null) break block16;
            }
            object = computedType = simpleType2;
        }
        if (proto.hasClassName()) {
            ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), proto.getClassName());
            return this.c.getComponents().getPlatformDependentTypeTransformer().transformPlatformType(classId, (SimpleType)computedType);
        }
        return computedType;
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return typeDeserializer.simpleType(type2, bl);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        ClassifierDescriptor classifierDescriptor;
        if (proto.hasClassName()) {
            classifierDescriptor = this.classifierDescriptors.invoke(proto.getClassName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getClassName());
            }
        } else if (proto.hasTypeParameter()) {
            TypeParameterDescriptor typeParameterDescriptor = this.loadTypeParameter(proto.getTypeParameter());
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{String.valueOf(proto.getTypeParameter()), this.containerPresentableName};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (proto.hasTypeParameterName()) {
            Object v2;
            String name;
            block13: {
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = this.getOwnTypeParameters();
                for (Object t : iterable) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v2 = t;
                    break block13;
                }
                v2 = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = v2;
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{name, this.c.getContainingDeclaration().toString()};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER_BY_NAME, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (proto.hasTypeAliasName()) {
            classifierDescriptor = this.typeAliasDescriptors.invoke(proto.getTypeAliasName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getTypeAliasName());
            }
        } else {
            return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.UNKNOWN_TYPE, new String[0]);
        }
        ClassifierDescriptor classifier2 = classifierDescriptor;
        TypeConstructor typeConstructor2 = classifier2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "classifier.typeConstructor");
        return typeConstructor2;
    }

    private final SimpleType createSuspendFunctionType(TypeAttributes attributes, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType result2;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (functionTypeConstructor.getParameters().size() - arguments2.size()) {
            case 0: {
                simpleType3 = this.createSuspendFunctionTypeForBasicCase(attributes, functionTypeConstructor, arguments2, nullable);
                break;
            }
            case 1: {
                int arity = arguments2.size() - 1;
                if (arity >= 0) {
                    TypeConstructor typeConstructor2 = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity).getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue(typeConstructor2, "functionTypeConstructor.\u2026on(arity).typeConstructor");
                    simpleType3 = KotlinTypeFactory.simpleType$default(attributes, typeConstructor2, arguments2, nullable, null, 16, null);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (result2 = simpleType3)) == null) {
            simpleType2 = ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.INCONSISTENT_SUSPEND_FUNCTION, arguments2, functionTypeConstructor, new String[0]);
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(TypeAttributes attributes, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType functionType = KotlinTypeFactory.simpleType$default(attributes, functionTypeConstructor, arguments2, nullable, null, 16, null);
        return !FunctionTypesKt.isFunctionType(functionType) ? null : this.transformRuntimeFunctionTypeToSuspendFunction(functionType);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType funType) {
        FqName continuationArgumentFqName;
        Object object = CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType));
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object continuationArgumentType = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)continuationArgumentType).getConstructor().getDeclarationDescriptor();
        FqName fqName2 = continuationArgumentFqName = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
        if (((KotlinType)continuationArgumentType).getArguments().size() != 1 || !Intrinsics.areEqual(continuationArgumentFqName, StandardNames.CONTINUATION_INTERFACE_FQ_NAME) && !Intrinsics.areEqual(continuationArgumentFqName, TypeDeserializerKt.access$getEXPERIMENTAL_CONTINUATION_FQ_NAME$p())) {
            return (SimpleType)funType;
        }
        KotlinType kotlinType = CollectionsKt.single(((KotlinType)continuationArgumentType).getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "continuationArgumentType.arguments.single().type");
        KotlinType suspendReturnType = kotlinType;
        DeclarationDescriptor $this$safeAs$iv = this.c.getContainingDeclaration();
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (Intrinsics.areEqual(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null, SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
        }
        return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType createSimpleSuspendFunctionType(KotlinType funType, KotlinType suspendReturnType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType), 1);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(funType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(funType);
        Annotations annotations2 = funType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(funType);
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getType());
        }
        collection = (List)destination$iv$iv;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, (List<? extends KotlinType>)collection, null, suspendReturnType, true).makeNullableAsSpecified(funType.isMarkedNullable());
    }

    private final TypeParameterDescriptor loadTypeParameter(int typeParameterId) {
        TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptors.get(typeParameterId);
        if (typeParameterDescriptor == null) {
            TypeDeserializer typeDeserializer = this.parent;
            typeParameterDescriptor = typeDeserializer != null ? typeDeserializer.loadTypeParameter(typeParameterId) : null;
        }
        return typeParameterDescriptor;
    }

    private final ClassifierDescriptor computeClassifierDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return this.c.getComponents().deserializeClass(id);
        }
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), className).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return parameter == null ? (TypeProjection)new StarProjectionForAbsentTypeParameter(this.c.getComponents().getModuleDescriptor().getBuiltIns()) : (TypeProjection)new StarProjectionImpl(parameter);
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue(projection, "typeArgumentProto.projection");
        Variance projection2 = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            String[] stringArray = new String[]{typeArgumentProto.toString()};
            return new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.NO_RECORDED_TYPE, stringArray));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(projection2, this.type(type3));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, TypeDeserializer this$0) {
        List<ProtoBuf.Type.Argument> list = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, "argumentList");
        Collection collection = list;
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.c.getTypeTable());
        List<ProtoBuf.Type.Argument> list2 = type2 != null ? TypeDeserializer.simpleType$collectAllArguments(type2, this$0) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    private static final ClassDescriptor typeConstructor$notFoundClass(TypeDeserializer this$0, ProtoBuf.Type $proto, int classIdIndex) {
        ClassId classId = NameResolverUtilKt.getClassId(this$0.c.getNameResolver(), classIdIndex);
        List<Integer> typeParametersCount2 = SequencesKt.toMutableList(SequencesKt.map(SequencesKt.generateSequence($proto, (Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this$0){
            final /* synthetic */ TypeDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ProtoTypeTableUtilKt.outerType(it, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
            }
        }), typeConstructor.notFoundClass.typeParametersCount.2.INSTANCE));
        int classNestingLevel2 = SequencesKt.count(SequencesKt.generateSequence(classId, (Function1)typeConstructor.notFoundClass.classNestingLevel.1.INSTANCE));
        while (typeParametersCount2.size() < classNestingLevel2) {
            typeParametersCount2.add(0);
        }
        return this$0.c.getComponents().getNotFoundClasses().getClass(classId, typeParametersCount2);
    }

    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    public static final /* synthetic */ ClassifierDescriptor access$computeClassifierDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassifierDescriptor(fqNameIndex);
    }

    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

