/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics5.BaseMeteredClient;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;

public class MeteredClient
extends BaseMeteredClient
implements Client {
    private final Client client;

    public MeteredClient(Client client, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        super(metricRegistry, new FeignMetricName(Client.class), metricSuppliers);
        this.client = client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        RequestTemplate template = request.requestTemplate();
        try (Timer.Context timer = this.createTimer(template);){
            Response response = this.client.execute(request, options);
            this.recordSuccess(template, response);
            Response response2 = response;
            return response2;
        }
        catch (FeignException e) {
            this.recordFailure(template, e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.recordFailure(template, e);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(template, e);
            throw new IOException(e);
        }
    }
}

