/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import feign.MethodMetadata;
import feign.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;

public final class FeignMetricName {
    private final Class<?> meteredComponent;

    public FeignMetricName(Class<?> meteredComponent) {
        this.meteredComponent = meteredComponent;
    }

    public String metricName(MethodMetadata methodMetadata, Target<?> target, String suffix) {
        return MetricRegistry.name((String)this.metricName(methodMetadata, target), (String[])new String[]{suffix});
    }

    public String metricName(MethodMetadata methodMetadata, Target<?> target) {
        return this.metricName(methodMetadata.targetType(), methodMetadata.method(), target.url());
    }

    public String metricName(Class<?> targetType, Method method, String url) {
        return MetricRegistry.name(this.meteredComponent, (String[])new String[]{targetType.getName(), method.getName(), this.extractHost(url)});
    }

    private String extractHost(String targetUrl) {
        try {
            return new URI(targetUrl).getHost();
        }
        catch (URISyntaxException e) {
            return targetUrl.length() <= 20 ? targetUrl : targetUrl.substring(0, 20);
        }
    }
}

