/*
 * Decompiled with CFR 0.152.
 */
package feign.benchmark;

import com.fasterxml.jackson.core.type.TypeReference;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonIteratorDecoder;
import feign.stream.StreamDecoder;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
public class DecoderIteratorsBenchmark {
    @Param(value={"list", "iterator", "stream"})
    private String api;
    @Param(value={"10", "100"})
    private String size;
    private Response response;
    private Decoder decoder;
    private Type type;

    @Benchmark
    @Warmup(iterations=5, time=1)
    @Measurement(iterations=10, time=1)
    @Fork(value=3)
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void decode() throws Exception {
        this.fetch(this.decoder.decode(this.response, this.type));
    }

    private void fetch(Object o) {
        Iterator cars = o instanceof Collection ? ((Collection)o).iterator() : (o instanceof Stream ? ((Stream)o).iterator() : (Iterator)o);
        while (cars.hasNext()) {
            cars.next();
        }
    }

    @Setup(value=Level.Invocation)
    public void buildResponse() {
        this.response = Response.builder().status(200).reason("OK").headers(Collections.emptyMap()).body(this.carsJson(Integer.valueOf(this.size)), Util.UTF_8).build();
    }

    @Setup(value=Level.Trial)
    public void buildDecoder() {
        switch (this.api) {
            case "list": {
                this.decoder = new JacksonDecoder();
                this.type = new TypeReference<List<Car>>(){}.getType();
                break;
            }
            case "iterator": {
                this.decoder = JacksonIteratorDecoder.create();
                this.type = new TypeReference<Iterator<Car>>(){}.getType();
                break;
            }
            case "stream": {
                this.decoder = StreamDecoder.create(JacksonIteratorDecoder.create());
                this.type = new TypeReference<Stream<Car>>(){}.getType();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown api: " + this.api);
            }
        }
    }

    private String carsJson(int count) {
        String car = "{\"name\":\"c4\",\"manufacturer\":\"Citro\u00ebn\"}";
        StringBuilder builder = new StringBuilder("[");
        builder.append(car);
        for (int i = 1; i < count; ++i) {
            builder.append(",").append(car);
        }
        return builder.append("]").toString();
    }

    static class Car {
        public String name;
        public String manufacturer;

        Car() {
        }
    }
}

