/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.threads;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PreferCurrentEventLoopGroup
implements EventLoopGroup {
    private final FastThreadLocal<EventLoop> self = new FastThreadLocal();
    private final EventLoopGroup delegate;

    public PreferCurrentEventLoopGroup(EventLoopGroup delegate) {
        this.delegate = delegate;
        for (final EventExecutor child : delegate) {
            child.submit(new Runnable(){

                @Override
                public void run() {
                    if (child instanceof EventLoop) {
                        PreferCurrentEventLoopGroup.this.self.set((EventLoop)child);
                    }
                }
            });
        }
    }

    @Override
    public EventLoop next() {
        EventLoop thisEventLoop = this.self.get();
        return null != thisEventLoop ? thisEventLoop : this.delegate.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    @Override
    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    @Override
    public io.netty.util.concurrent.Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    @Override
    public io.netty.util.concurrent.Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    @Override
    public io.netty.util.concurrent.Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    @Override
    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    @Deprecated
    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public io.netty.util.concurrent.Future<?> submit(Runnable task) {
        return this.next().submit(task);
    }

    @Override
    public <T> io.netty.util.concurrent.Future<T> submit(Runnable task, T result) {
        return this.next().submit(task, result);
    }

    @Override
    public <T> io.netty.util.concurrent.Future<T> submit(Callable<T> task) {
        return this.next().submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.next().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.next().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.next().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.next().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.next().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.next().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.next().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.next().invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.next().execute(command);
    }
}

