/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.ws.server.V7to13Handshaker;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandler;
import rx.Observable;
import rx.Subscriber;

public abstract class WebSocketHandshaker
extends Observable<Void> {
    public static final int DEFAULT_MAX_FRAME_PAYLOAD_LENGTH = 65536;
    public static final boolean DEFAULT_ALLOW_EXTENSIONS = true;

    protected WebSocketHandshaker(Observable.OnSubscribe<Void> f) {
        super(f);
    }

    public abstract WebSocketHandshaker subprotocol(String ... var1);

    public abstract WebSocketHandshaker allowExtensions(boolean var1);

    public abstract WebSocketHandshaker location(String var1);

    public abstract WebSocketHandshaker maxFramePayloadLength(int var1);

    public static WebSocketHandshaker newHandshaker(HttpServerRequest<?> request, HttpServerResponse<?> upgradeResponse, WebSocketHandler handler) {
        WebSocketVersion wsVersion = WebSocketHandshaker.getWsVersion(request);
        return V7to13Handshaker.createNew(wsVersion, request, upgradeResponse, handler);
    }

    public static WebSocketHandshaker newErrorHandshaker(Throwable error) {
        return new ErrorWebSocketHandshaker(error);
    }

    protected static String selectSubprotocol(String requestedSubprotocols, String[] supportedSubProtocols) {
        String[] requestedSubprotocolArray;
        if (requestedSubprotocols == null || supportedSubProtocols.length == 0) {
            return null;
        }
        for (String p : requestedSubprotocolArray = requestedSubprotocols.split(",")) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : supportedSubProtocols) {
                if (!"*".equals(supportedSubprotocol) && !requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return requestedSubprotocol;
            }
        }
        return null;
    }

    public static boolean isUpgradeRequested(HttpServerRequest<?> upgradeRequest) {
        return null != upgradeRequest && upgradeRequest.containsHeader(HttpHeaderNames.UPGRADE) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgradeRequest.getHeader(HttpHeaderNames.UPGRADE));
    }

    public static boolean isUpgradeRequested(HttpRequest upgradeRequest) {
        return null != upgradeRequest && upgradeRequest.headers().contains(HttpHeaderNames.UPGRADE) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgradeRequest.headers().get(HttpHeaderNames.UPGRADE));
    }

    private static WebSocketVersion getWsVersion(HttpServerRequest<?> request) {
        String version;
        switch (version = request.getHeader(HttpHeaderNames.SEC_WEBSOCKET_VERSION)) {
            case "0": {
                return WebSocketVersion.V00;
            }
            case "7": {
                return WebSocketVersion.V07;
            }
            case "8": {
                return WebSocketVersion.V08;
            }
            case "13": {
                return WebSocketVersion.V13;
            }
        }
        return WebSocketVersion.UNKNOWN;
    }

    private static class ErrorWebSocketHandshaker
    extends WebSocketHandshaker {
        public ErrorWebSocketHandshaker(final Throwable error) {
            super(new Observable.OnSubscribe<Void>(){

                @Override
                public void call(Subscriber<? super Void> subscriber) {
                    subscriber.onError(error);
                }
            });
        }

        @Override
        public WebSocketHandshaker subprotocol(String ... subprotocols) {
            return this;
        }

        @Override
        public WebSocketHandshaker allowExtensions(boolean allowExtensions) {
            return this;
        }

        @Override
        public WebSocketHandshaker location(String webSocketLocation) {
            return this;
        }

        @Override
        public WebSocketHandshaker maxFramePayloadLength(int maxFramePayloadLength) {
            return this;
        }
    }
}

