/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.protocol.http.internal.HttpMessageFormatter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;

public abstract class HttpServerRequest<T> {
    public abstract HttpMethod getHttpMethod();

    public abstract HttpVersion getHttpVersion();

    public abstract String getUri();

    public abstract String getDecodedPath();

    public abstract String getRawQueryString();

    public abstract Map<String, Set<Cookie>> getCookies();

    public abstract Map<String, List<String>> getQueryParameters();

    public abstract boolean containsHeader(CharSequence var1);

    public abstract boolean containsHeader(CharSequence var1, CharSequence var2, boolean var3);

    public abstract Iterator<Map.Entry<CharSequence, CharSequence>> headerIterator();

    public abstract String getHeader(CharSequence var1);

    public abstract String getHeader(CharSequence var1, String var2);

    public abstract List<String> getAllHeaderValues(CharSequence var1);

    public abstract long getContentLength();

    public abstract long getContentLength(long var1);

    public abstract long getDateHeader(CharSequence var1);

    public abstract long getDateHeader(CharSequence var1, long var2);

    public abstract String getHostHeader();

    public abstract String getHostHeader(String var1);

    public abstract int getIntHeader(CharSequence var1);

    public abstract int getIntHeader(CharSequence var1, int var2);

    public abstract boolean is100ContinueExpected();

    public abstract boolean isContentLengthSet();

    public abstract boolean isKeepAlive();

    public abstract boolean isTransferEncodingChunked();

    public abstract Set<String> getHeaderNames();

    public abstract HttpServerRequest<T> addHeader(CharSequence var1, Object var2);

    public abstract HttpServerRequest<T> addCookie(Cookie var1);

    public abstract HttpServerRequest<T> addDateHeader(CharSequence var1, Date var2);

    public abstract HttpServerRequest<T> addDateHeader(CharSequence var1, Iterable<Date> var2);

    public abstract HttpServerRequest<T> addHeader(CharSequence var1, Iterable<Object> var2);

    public abstract HttpServerRequest<T> setDateHeader(CharSequence var1, Date var2);

    public abstract HttpServerRequest<T> setHeader(CharSequence var1, Object var2);

    public abstract HttpServerRequest<T> setDateHeader(CharSequence var1, Iterable<Date> var2);

    public abstract HttpServerRequest<T> setHeader(CharSequence var1, Iterable<Object> var2);

    public abstract HttpServerRequest<T> removeHeader(CharSequence var1);

    public abstract ContentSource<T> getContent();

    public abstract Observable<Void> discardContent();

    public abstract Observable<Void> dispose();

    public abstract boolean isWebSocketUpgradeRequested();

    public abstract <X> HttpServerRequest<X> transformContent(Observable.Transformer<T, X> var1);

    abstract DecoderResult decoderResult();

    public String toString() {
        return HttpMessageFormatter.formatRequest(this.getHttpVersion(), this.getHttpMethod(), this.getUri(), this.headerIterator());
    }
}

