/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileBuckets;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class PercentileDistributionSummary
implements DistributionSummary {
    private static final String[] TAG_VALUES;
    private final Registry registry;
    private final Id id;
    private final DistributionSummary summary;
    private final AtomicReferenceArray<Counter> counters;

    public static PercentileDistributionSummary get(Registry registry, Id id) {
        return new PercentileDistributionSummary(registry, id);
    }

    PercentileDistributionSummary(Registry registry, Id id) {
        this.registry = registry;
        this.id = id;
        this.summary = registry.distributionSummary(id);
        this.counters = new AtomicReferenceArray(PercentileBuckets.length());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.summary.hasExpired();
    }

    private Counter counterFor(int i) {
        Counter c = this.counters.get(i);
        if (c == null) {
            Id counterId = this.id.withTag("percentile", TAG_VALUES[i]);
            c = this.registry.counter(counterId);
            this.counters.set(i, c);
        }
        return c;
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.summary.record(amount);
            this.counterFor(PercentileBuckets.indexOf(amount)).increment();
        }
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counterFor(i).count();
        }
        return PercentileBuckets.percentile(counts, p);
    }

    @Override
    public long count() {
        return this.summary.count();
    }

    @Override
    public long totalAmount() {
        return this.summary.totalAmount();
    }

    static {
        int length = PercentileBuckets.length();
        TAG_VALUES = new String[length];
        for (int i = 0; i < length; ++i) {
            PercentileDistributionSummary.TAG_VALUES[i] = String.format("D%04X", i);
        }
    }
}

