/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import io.reactivex.netty.spectator.http.internal.ResponseCodesHolder;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;

public class HttpServerListener
extends HttpServerEventsListener {
    private final EventMetric requestRead;
    private final EventMetric requestProcessing;
    private final EventMetric responseWrite;
    private final ResponseCodesHolder responseCodesHolder;
    private final TcpServerListener tcpDelegate;

    public HttpServerListener(String monitorId) {
        this(Spectator.globalRegistry(), monitorId);
    }

    public HttpServerListener(Registry registry, String monitorId) {
        this.requestRead = new EventMetric(registry, "request", monitorId, "action", "read");
        this.requestProcessing = new EventMetric(registry, "request", monitorId, "action", "processing");
        this.responseWrite = new EventMetric(registry, "response", monitorId, "action", "write");
        this.responseCodesHolder = new ResponseCodesHolder(registry, monitorId);
        this.tcpDelegate = new TcpServerListener(registry, monitorId);
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    @Override
    public void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.requestProcessing.failure(duration, timeUnit);
    }

    @Override
    public void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.requestProcessing.success(duration, timeUnit);
    }

    @Override
    public void onResponseWriteSuccess(long duration, TimeUnit timeUnit, int responseCode) {
        this.responseWrite.success(duration, timeUnit);
    }

    @Override
    public void onResponseWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.responseWrite.failure(duration, timeUnit);
    }

    @Override
    public void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
        this.requestRead.success(duration, timeUnit);
    }

    @Override
    public void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
        this.requestProcessing.start(duration, timeUnit);
    }

    @Override
    public void onRequestHeadersReceived() {
        this.requestRead.start();
    }

    @Override
    public void onResponseWriteStart() {
        this.responseWrite.start();
    }

    @Override
    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionHandlingStart(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onNewClientConnected() {
        this.tcpDelegate.onNewClientConnected();
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    @Override
    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }
}

