/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws;

import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import rx.Observable;
import rx.annotations.Beta;
import rx.functions.Func1;

public final class WebSocketConnection {
    private final Connection<WebSocketFrame, WebSocketFrame> delegate;

    public WebSocketConnection(Connection<WebSocketFrame, WebSocketFrame> delegate) {
        this.delegate = delegate;
    }

    public Observable<WebSocketFrame> getInput() {
        return this.getInput(true);
    }

    @Beta
    public Observable<WebSocketFrame> getInput(boolean untilCloseFrame) {
        ContentSource<WebSocketFrame> rawInput = this.delegate.getInput();
        if (untilCloseFrame) {
            return rawInput.takeUntil(new Func1<WebSocketFrame, Boolean>(){

                @Override
                public Boolean call(WebSocketFrame webSocketFrame) {
                    return webSocketFrame instanceof CloseWebSocketFrame;
                }
            });
        }
        return rawInput;
    }

    public Observable<Void> write(Observable<WebSocketFrame> msgs) {
        return this.delegate.write(msgs);
    }

    public Observable<Void> write(Observable<WebSocketFrame> msgs, Func1<WebSocketFrame, Boolean> flushSelector) {
        return this.delegate.write(msgs, flushSelector);
    }

    public Observable<Void> writeAndFlushOnEach(Observable<WebSocketFrame> msgs) {
        return this.delegate.writeAndFlushOnEach(msgs);
    }

    public void flush() {
        this.delegate.flush();
    }

    public Observable<Void> close() {
        return this.delegate.close();
    }

    public Observable<Void> close(boolean flush) {
        return this.delegate.close(flush);
    }

    public Observable<Void> closeListener() {
        return this.delegate.closeListener();
    }

    public void closeNow() {
        this.delegate.closeNow();
    }
}

