/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.Collection;
import java.util.Iterator;

final class CompositeCounter
extends CompositeMeter
implements Counter {
    CompositeCounter(Id id, Collection<Registry> registries) {
        super(id, registries);
    }

    @Override
    public void increment() {
        for (Registry r : this.registries) {
            r.counter(this.id).increment();
        }
    }

    @Override
    public void increment(long amount) {
        for (Registry r : this.registries) {
            r.counter(this.id).increment(amount);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? ((Registry)it.next()).counter(this.id).count() : 0L;
    }
}

