/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func0;
import rx.internal.operators.BufferUntilSubscriber;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

public final class OperatorWindowWithObservableFactory<T, U>
implements Observable.Operator<Observable<T>, T> {
    final Func0<? extends Observable<? extends U>> otherFactory;
    static final Object NEXT_SUBJECT = new Object();
    static final NotificationLite<Object> nl = NotificationLite.instance();

    public OperatorWindowWithObservableFactory(Func0<? extends Observable<? extends U>> otherFactory) {
        this.otherFactory = otherFactory;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        SourceSubscriber sub = new SourceSubscriber(child, this.otherFactory);
        child.add(sub);
        sub.replaceWindow();
        return sub;
    }

    static final class BoundarySubscriber<T, U>
    extends Subscriber<U> {
        final SourceSubscriber<T, U> sub;
        boolean done;

        public BoundarySubscriber(Subscriber<?> child, SourceSubscriber<T, U> sub) {
            this.sub = sub;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(U t) {
            if (!this.done) {
                this.done = true;
                this.sub.replaceWindow();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                this.sub.onCompleted();
            }
        }
    }

    static final class SourceSubscriber<T, U>
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final Object guard;
        Observer<T> consumer;
        Observable<T> producer;
        boolean emitting;
        List<Object> queue;
        final SerialSubscription ssub;
        final Func0<? extends Observable<? extends U>> otherFactory;

        public SourceSubscriber(Subscriber<? super Observable<T>> child, Func0<? extends Observable<? extends U>> otherFactory) {
            this.child = new SerializedSubscriber<Observable<? super Observable<T>>>(child);
            this.guard = new Object();
            this.ssub = new SerialSubscription();
            this.otherFactory = otherFactory;
            this.add(this.ssub);
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNext(T t) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(t);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.emitValue(t);
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void drain(List<Object> queue) {
            if (queue == null) {
                return;
            }
            for (Object o : queue) {
                if (o == NEXT_SUBJECT) {
                    this.replaceSubject();
                    continue;
                }
                if (nl.isError(o)) {
                    this.error(nl.getError(o));
                    break;
                }
                if (nl.isCompleted(o)) {
                    this.complete();
                    break;
                }
                Object t = o;
                this.emitValue(t);
            }
        }

        void replaceSubject() {
            Observer<T> s = this.consumer;
            if (s != null) {
                s.onCompleted();
            }
            this.createNewWindow();
            this.child.onNext(this.producer);
        }

        void createNewWindow() {
            Observable<U> other;
            BufferUntilSubscriber bus = BufferUntilSubscriber.create();
            this.consumer = bus;
            this.producer = bus;
            try {
                other = this.otherFactory.call();
            }
            catch (Throwable e) {
                this.child.onError(e);
                this.unsubscribe();
                return;
            }
            BoundarySubscriber bs = new BoundarySubscriber(this.child, this);
            this.ssub.set(bs);
            other.unsafeSubscribe(bs);
        }

        void emitValue(T t) {
            Observer<T> s = this.consumer;
            if (s != null) {
                s.onNext(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    this.queue = Collections.singletonList(nl.error(e));
                    return;
                }
                this.queue = null;
                this.emitting = true;
            }
            this.error(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(nl.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            try {
                this.drain(localQueue);
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void replaceWindow() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NEXT_SUBJECT);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.replaceSubject();
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void complete() {
            Observer<T> s = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s != null) {
                s.onCompleted();
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        void error(Throwable e) {
            Observer<T> s = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s != null) {
                s.onError(e);
            }
            this.child.onError(e);
            this.unsubscribe();
        }
    }
}

