/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpResponseHeaders {
    private final HttpResponse nettyResponse;
    private final HttpHeaders nettyHeaders;

    public HttpResponseHeaders(HttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
        this.nettyHeaders = this.nettyResponse.headers();
    }

    public HttpHeaders add(HttpHeaders headers) {
        return this.nettyHeaders.add(headers);
    }

    public HttpHeaders add(CharSequence name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public HttpHeaders add(String name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public void addDateHeader(CharSequence name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void addDateHeader(String name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void addHeader(CharSequence name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void addHeader(String name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void addIntHeader(CharSequence name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void addIntHeader(String name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public HttpHeaders clear() {
        return this.nettyHeaders.clear();
    }

    public void clearHeaders() {
        HttpHeaders.clearHeaders(this.nettyResponse);
    }

    public boolean contains(CharSequence name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii(seq, buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase(name1, name2);
    }

    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength(this.nettyResponse);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength(this.nettyResponse, defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate(this.nettyResponse);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate(this.nettyResponse, defaultValue);
    }

    public Date getDateHeader(CharSequence name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name);
    }

    public Date getDateHeader(CharSequence name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name);
    }

    public Date getDateHeader(String name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public String getHeader(CharSequence name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name);
    }

    public String getHeader(CharSequence name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name);
    }

    public String getHeader(String name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost(this.nettyResponse);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost(this.nettyResponse, defaultValue);
    }

    public int getIntHeader(CharSequence name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name);
    }

    public int getIntHeader(CharSequence name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name);
    }

    public int getIntHeader(String name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name, defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected(this.nettyResponse);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet(this.nettyResponse);
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this.nettyResponse);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked(this.nettyResponse);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    public CharSequence newEntity(String name) {
        return HttpHeaders.newEntity(name);
    }

    public HttpHeaders remove(CharSequence name) {
        return this.nettyHeaders.remove(name);
    }

    public HttpHeaders remove(String name) {
        return this.nettyHeaders.remove(name);
    }

    public void removeHeader(CharSequence name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyResponse, name);
    }

    public void removeHeader(String name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyResponse, name);
    }

    public void removeTransferEncodingChunked() {
        HttpHeaders.removeTransferEncodingChunked(this.nettyResponse);
    }

    public HttpHeaders set(HttpHeaders headers) {
        return this.nettyHeaders.set(headers);
    }

    public HttpHeaders set(CharSequence name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public HttpHeaders set(String name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public void set100ContinueExpected() {
        HttpHeaders.set100ContinueExpected(this.nettyResponse);
    }

    public void set100ContinueExpected(boolean set) {
        HttpHeaders.set100ContinueExpected(this.nettyResponse, set);
    }

    public void setContentLength(long length) {
        HttpHeaders.setContentLength(this.nettyResponse, length);
    }

    public void setDate(Date value) {
        HttpHeaders.setDate(this.nettyResponse, value);
    }

    public void setDateHeader(CharSequence name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setDateHeader(CharSequence name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setDateHeader(String name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setDateHeader(String name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setHeader(CharSequence name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setHeader(CharSequence name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setHeader(String name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setHeader(String name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setHost(CharSequence value) {
        HttpHeaders.setHost((HttpMessage)this.nettyResponse, value);
    }

    public void setHost(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyResponse, value);
    }

    public void setIntHeader(CharSequence name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setIntHeader(CharSequence name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setIntHeader(String name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name, value);
    }

    public void setIntHeader(String name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name, values);
    }

    public void setKeepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive(this.nettyResponse, keepAlive);
    }

    public void setTransferEncodingChunked() {
        HttpHeaders.setTransferEncodingChunked(this.nettyResponse);
    }
}

