/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequestHeaders {
    private final HttpRequest nettyRequest;
    private final HttpHeaders nettyHeaders;

    public HttpRequestHeaders(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.nettyHeaders = this.nettyRequest.headers();
    }

    public HttpHeaders add(HttpHeaders headers) {
        return this.nettyHeaders.add(headers);
    }

    public HttpHeaders add(CharSequence name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public HttpHeaders add(String name, Object value) {
        return this.nettyHeaders.add(name, value);
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        return this.nettyHeaders.add(name, values);
    }

    public void addDateHeader(CharSequence name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void addDateHeader(String name, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void addHeader(CharSequence name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void addHeader(String name, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void addIntHeader(CharSequence name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void addIntHeader(String name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public HttpHeaders clear() {
        return this.nettyHeaders.clear();
    }

    public void clearHeaders() {
        HttpHeaders.clearHeaders(this.nettyRequest);
    }

    public boolean contains(CharSequence name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii(seq, buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase(name1, name2);
    }

    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    public String get(String name) {
        return this.nettyHeaders.get(name);
    }

    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    public List<String> getAll(String name) {
        return this.nettyHeaders.getAll(name);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength(this.nettyRequest);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength(this.nettyRequest, defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate(this.nettyRequest);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate(this.nettyRequest, defaultValue);
    }

    public Date getDateHeader(CharSequence name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name);
    }

    public Date getDateHeader(CharSequence name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public Date getDateHeader(String name) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name);
    }

    public Date getDateHeader(String name, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public String getHeader(CharSequence name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name);
    }

    public String getHeader(CharSequence name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name);
    }

    public String getHeader(String name, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost(this.nettyRequest);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost(this.nettyRequest, defaultValue);
    }

    public int getIntHeader(CharSequence name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name);
    }

    public int getIntHeader(CharSequence name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name);
    }

    public int getIntHeader(String name, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyRequest, name, defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected(this.nettyRequest);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet(this.nettyRequest);
    }

    public boolean hasContent() {
        if (this.isContentLengthSet()) {
            return this.getContentLength() > 0L;
        }
        return this.isTransferEncodingChunked();
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this.nettyRequest);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked(this.nettyRequest);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    public CharSequence newEntity(String name) {
        return HttpHeaders.newEntity(name);
    }

    public HttpHeaders remove(CharSequence name) {
        return this.nettyHeaders.remove(name);
    }

    public HttpHeaders remove(String name) {
        return this.nettyHeaders.remove(name);
    }

    public void removeHeader(CharSequence name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyRequest, name);
    }

    public void removeHeader(String name) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyRequest, name);
    }

    public void removeTransferEncodingChunked() {
        HttpHeaders.removeTransferEncodingChunked(this.nettyRequest);
    }

    public HttpHeaders set(HttpHeaders headers) {
        return this.nettyHeaders.set(headers);
    }

    public HttpHeaders set(CharSequence name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public HttpHeaders set(String name, Object value) {
        return this.nettyHeaders.set(name, value);
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        return this.nettyHeaders.set(name, values);
    }

    public void set100ContinueExpected() {
        HttpHeaders.set100ContinueExpected(this.nettyRequest);
    }

    public void set100ContinueExpected(boolean set) {
        HttpHeaders.set100ContinueExpected(this.nettyRequest, set);
    }

    public void setContentLength(long length) {
        HttpHeaders.setContentLength(this.nettyRequest, length);
    }

    public void setDate(Date value) {
        HttpHeaders.setDate(this.nettyRequest, value);
    }

    public void setDateHeader(CharSequence name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setDateHeader(CharSequence name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setDateHeader(String name, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setDateHeader(String name, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setHeader(CharSequence name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setHeader(CharSequence name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setHeader(String name, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setHeader(String name, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setHost(CharSequence value) {
        HttpHeaders.setHost((HttpMessage)this.nettyRequest, value);
    }

    public void setHost(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyRequest, value);
    }

    public void setIntHeader(CharSequence name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setIntHeader(CharSequence name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setIntHeader(String name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, name, value);
    }

    public void setIntHeader(String name, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyRequest, name, values);
    }

    public void setKeepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive(this.nettyRequest, keepAlive);
    }

    public void setTransferEncodingChunked() {
        HttpHeaders.setTransferEncodingChunked(this.nettyRequest);
    }
}

