/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql.apt;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import feign.graphql.apt.GraphqlTypeMapper;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class TypeGenerator {
    private final Filer filer;
    private final Messager messager;
    private final TypeDefinitionRegistry registry;
    private final GraphqlTypeMapper typeMapper;
    private final String targetPackage;
    private final Set<String> generatedTypes = new HashSet<String>();
    private final Queue<String> pendingTypes = new ArrayDeque<String>();

    public TypeGenerator(Filer filer, Messager messager, TypeDefinitionRegistry registry, GraphqlTypeMapper typeMapper, String targetPackage) {
        this.filer = filer;
        this.messager = messager;
        this.registry = registry;
        this.typeMapper = typeMapper;
        this.targetPackage = targetPackage;
    }

    public void generateResultType(String className, SelectionSet selectionSet, ObjectTypeDefinition parentType, Element element) {
        if (this.generatedTypes.contains(className)) {
            return;
        }
        this.generatedTypes.add(className);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (Selection selection : selectionSet.getSelections()) {
            Field field;
            String fieldName;
            FieldDefinition schemaDef;
            if (!(selection instanceof Field) || (schemaDef = this.findFieldDefinition(parentType, fieldName = (field = (Field)selection).getName())) == null) continue;
            Type fieldType = schemaDef.getType();
            String rawTypeName = this.unwrapTypeName(fieldType);
            if (field.getSelectionSet() != null && !field.getSelectionSet().getSelections().isEmpty()) {
                String nestedClassName = this.capitalize(fieldName);
                this.generateNestedResultType(nestedClassName, field.getSelectionSet(), rawTypeName, element);
                TypeName nestedType = this.wrapType(fieldType, (TypeName)ClassName.get((String)this.targetPackage, (String)nestedClassName, (String[])new String[0]));
                fields.add(this.toRecordField(fieldName, nestedType));
                continue;
            }
            TypeName javaType = this.typeMapper.map(fieldType);
            fields.add(this.toRecordField(fieldName, javaType));
            this.enqueueIfNonScalar(rawTypeName);
        }
        this.writeRecord(className, fields, element);
        this.processPendingTypes(element);
    }

    public void generateInputType(String className, String graphqlTypeName, Element element) {
        if (this.generatedTypes.contains(className)) {
            return;
        }
        this.generatedTypes.add(className);
        Optional maybeDef = this.registry.getType(graphqlTypeName, InputObjectTypeDefinition.class);
        if (maybeDef.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "GraphQL input type not found: " + graphqlTypeName, element);
            return;
        }
        InputObjectTypeDefinition inputDef = (InputObjectTypeDefinition)maybeDef.get();
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (InputValueDefinition valueDef : inputDef.getInputValueDefinitions()) {
            String fieldName = valueDef.getName();
            Type fieldType = valueDef.getType();
            TypeName javaType = this.typeMapper.map(fieldType);
            fields.add(this.toRecordField(fieldName, javaType));
            String rawTypeName = this.unwrapTypeName(fieldType);
            this.enqueueIfNonScalar(rawTypeName);
        }
        this.writeRecord(className, fields, element);
        this.processPendingTypes(element);
    }

    private void generateNestedResultType(String className, SelectionSet selectionSet, String graphqlTypeName, Element element) {
        if (this.generatedTypes.contains(className)) {
            return;
        }
        Optional maybeDef = this.registry.getType(graphqlTypeName, ObjectTypeDefinition.class);
        if (maybeDef.isEmpty()) {
            return;
        }
        this.generateResultType(className, selectionSet, (ObjectTypeDefinition)maybeDef.get(), element);
    }

    private void processPendingTypes(Element element) {
        while (!this.pendingTypes.isEmpty()) {
            String typeName = this.pendingTypes.poll();
            if (this.generatedTypes.contains(typeName)) continue;
            Optional enumDef = this.registry.getType(typeName, EnumTypeDefinition.class);
            if (enumDef.isPresent()) {
                this.generateEnum(typeName, (EnumTypeDefinition)enumDef.get(), element);
                continue;
            }
            Optional inputDef = this.registry.getType(typeName, InputObjectTypeDefinition.class);
            if (inputDef.isPresent()) {
                this.generateInputType(typeName, typeName, element);
                continue;
            }
            Optional objectDef = this.registry.getType(typeName, ObjectTypeDefinition.class);
            if (!objectDef.isPresent()) continue;
            this.generateFullObjectType(typeName, (ObjectTypeDefinition)objectDef.get(), element);
        }
    }

    private void generateEnum(String className, EnumTypeDefinition enumDef, Element element) {
        if (this.generatedTypes.contains(className)) {
            return;
        }
        this.generatedTypes.add(className);
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (EnumValueDefinition value : enumDef.getEnumValueDefinitions()) {
            enumBuilder.addEnumConstant(value.getName());
        }
        this.writeType(enumBuilder.build(), element);
    }

    private void generateFullObjectType(String className, ObjectTypeDefinition objectDef, Element element) {
        if (this.generatedTypes.contains(className)) {
            return;
        }
        this.generatedTypes.add(className);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (FieldDefinition fieldDef : objectDef.getFieldDefinitions()) {
            String fieldName = fieldDef.getName();
            TypeName javaType = this.typeMapper.map(fieldDef.getType());
            fields.add(this.toRecordField(fieldName, javaType));
            String rawTypeName = this.unwrapTypeName(fieldDef.getType());
            this.enqueueIfNonScalar(rawTypeName);
        }
        this.writeRecord(className, fields, element);
        this.processPendingTypes(element);
    }

    private void enqueueIfNonScalar(String typeName) {
        if (!this.typeMapper.isScalar(typeName) && !this.generatedTypes.contains(typeName)) {
            this.pendingTypes.add(typeName);
        }
    }

    private FieldDefinition findFieldDefinition(ObjectTypeDefinition typeDef, String fieldName) {
        for (FieldDefinition fd : typeDef.getFieldDefinitions()) {
            if (!fd.getName().equals(fieldName)) continue;
            return fd;
        }
        return null;
    }

    private String unwrapTypeName(Type<?> type) {
        if (type instanceof NonNullType) {
            NonNullType nullType = (NonNullType)type;
            return this.unwrapTypeName(nullType.getType());
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return this.unwrapTypeName(listType.getType());
        }
        if (type instanceof graphql.language.TypeName) {
            graphql.language.TypeName name = (graphql.language.TypeName)type;
            return name.getName();
        }
        return "String";
    }

    private TypeName wrapType(Type<?> schemaType, TypeName innerType) {
        if (schemaType instanceof NonNullType) {
            NonNullType type = (NonNullType)schemaType;
            return this.wrapType(type.getType(), innerType);
        }
        if (schemaType instanceof ListType) {
            ListType type = (ListType)schemaType;
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.wrapType(type.getType(), innerType)});
        }
        return innerType;
    }

    private String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private void writeType(TypeSpec typeSpec, Element element) {
        try {
            JavaFile javaFile = JavaFile.builder((String)this.targetPackage, (TypeSpec)typeSpec).build();
            javaFile.writeTo(this.filer);
        }
        catch (FilerException javaFile) {
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated type " + typeSpec.name + ": " + e.getMessage(), element);
        }
    }

    private RecordField toRecordField(String name, TypeName typeName) {
        String typeString = this.typeNameToString(typeName);
        String importFqn = this.resolveImport(typeName);
        return new RecordField(typeString, name, importFqn, typeName);
    }

    private String typeNameToString(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)typeName;
            String raw = parameterized.rawType.simpleName();
            String typeArgs = parameterized.typeArguments.stream().map(this::typeNameToString).collect(Collectors.joining(", "));
            return raw + "<" + typeArgs + ">";
        }
        if (typeName instanceof ClassName) {
            ClassName name = (ClassName)typeName;
            return name.simpleName();
        }
        return typeName.toString();
    }

    private String resolveImport(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)typeName;
            this.resolveImport((TypeName)parameterized.rawType);
            for (TypeName typeArg : parameterized.typeArguments) {
                this.resolveImport(typeArg);
            }
            return this.fqnIfNeeded(parameterized.rawType);
        }
        if (typeName instanceof ClassName) {
            ClassName name = (ClassName)typeName;
            return this.fqnIfNeeded(name);
        }
        return null;
    }

    private String fqnIfNeeded(ClassName className) {
        String pkg = className.packageName();
        if (pkg.equals("java.lang") || pkg.equals(this.targetPackage) || pkg.isEmpty()) {
            return null;
        }
        return pkg + "." + className.simpleName();
    }

    private Set<String> collectImports(List<RecordField> fields) {
        TreeSet<String> imports = new TreeSet<String>();
        for (RecordField field : fields) {
            this.collectImportsFromTypeName(field.typeName, imports);
        }
        return imports;
    }

    private void collectImportsFromTypeName(TypeName typeName, Set<String> imports) {
        ClassName name;
        String fqn;
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)typeName;
            this.collectImportsFromTypeName((TypeName)parameterized.rawType, imports);
            for (TypeName typeArg : parameterized.typeArguments) {
                this.collectImportsFromTypeName(typeArg, imports);
            }
        } else if (typeName instanceof ClassName && (fqn = this.fqnIfNeeded(name = (ClassName)typeName)) != null) {
            imports.add(fqn);
        }
    }

    private void writeRecord(String className, List<RecordField> fields, Element element) {
        String fqn = this.targetPackage.isEmpty() ? className : this.targetPackage + "." + className;
        try {
            JavaFileObject sourceFile = this.filer.createSourceFile(fqn, element);
            try (PrintWriter out = new PrintWriter(sourceFile.openWriter());){
                Set<String> imports;
                if (!this.targetPackage.isEmpty()) {
                    out.println("package " + this.targetPackage + ";");
                    out.println();
                }
                if (!(imports = this.collectImports(fields)).isEmpty()) {
                    for (String imp : imports) {
                        out.println("import " + imp + ";");
                    }
                    out.println();
                }
                String params = fields.stream().map(f -> f.typeString + " " + f.name).collect(Collectors.joining(", "));
                out.println("public record " + className + "(" + params + ") {}");
            }
        }
        catch (FilerException sourceFile) {
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated type " + className + ": " + e.getMessage(), element);
        }
    }

    static class RecordField {
        final String typeString;
        final String name;
        final String importFqn;
        final TypeName typeName;

        RecordField(String typeString, String name, String importFqn) {
            this.typeString = typeString;
            this.name = name;
            this.importFqn = importFqn;
            this.typeName = null;
        }

        RecordField(String typeString, String name, String importFqn, TypeName typeName) {
            this.typeString = typeString;
            this.name = name;
            this.importFqn = importFqn;
            this.typeName = typeName;
        }
    }
}

