/*
 * Decompiled with CFR 0.152.
 */
package io.github.fragmentstack;

import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import io.github.fragmentstack.FragmentStack;
import io.github.fragmentstack.PageManagerBuilder;
import io.github.fragmentstack.listeners.FragmentPagerTransitionInterceptor;
import io.github.fragmentstack.views.FragmentPagerLifeCycleFragment;

public class PageManager {
    private final FragmentManager fragmentManager;
    private final int containerViewId;
    private Fragment defaultFragment;
    private FragmentPagerTransitionInterceptor localFragmentPagerTransitionInterceptor;

    PageManager(FragmentManager fragmentManager, @IdRes int containerViewId, Fragment defaultFragment) {
        this.fragmentManager = fragmentManager;
        this.containerViewId = containerViewId;
        this.defaultFragment = defaultFragment;
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public PageManagerBuilder localConfig() {
        return new PageManagerBuilder(this);
    }

    public PageManager localConfig(PageManagerBuilder builder) {
        this.localFragmentPagerTransitionInterceptor = builder.localFragmentPagerTransitionInterceptor;
        this.defaultFragment = builder.defaultFragment;
        if (this.defaultFragment != null) {
            this.fragmentManager.beginTransaction().add(this.containerViewId, this.defaultFragment, this.defaultFragment.getClass().getName()).commit();
        }
        return this;
    }

    public boolean hasPage() {
        return this.fragmentManager.getBackStackEntryCount() != 0;
    }

    public boolean back() {
        if (!this.hasPage()) {
            return false;
        }
        this.fragmentManager.popBackStackImmediate();
        FragmentPagerLifeCycleFragment fragmentPagerListener = this.getLastFragmentPagerListener();
        if (fragmentPagerListener != null) {
            fragmentPagerListener.onForeground();
        }
        return true;
    }

    public boolean back(int count) {
        if (!this.hasPage()) {
            return false;
        }
        int backStackEntryCount = this.fragmentManager.getBackStackEntryCount();
        int entryAt = backStackEntryCount - 1 - count;
        if (entryAt < 0) {
            entryAt = 0;
        }
        int id = this.fragmentManager.getBackStackEntryAt(entryAt).getId();
        this.fragmentManager.popBackStackImmediate(id, 0);
        FragmentPagerLifeCycleFragment fragmentPagerListener = this.getLastFragmentPagerListener();
        if (fragmentPagerListener != null) {
            fragmentPagerListener.onForeground();
        }
        return true;
    }

    public boolean back(Fragment fragment, int flags) {
        return this.back(fragment.getClass().getName(), flags);
    }

    public boolean back(Class cls, int flags) {
        return this.back(cls.getName(), flags);
    }

    public boolean back(String name, int flags) {
        if (!this.hasPage()) {
            return false;
        }
        this.fragmentManager.popBackStackImmediate(name, flags);
        FragmentPagerLifeCycleFragment fragmentPagerListener = this.getLastFragmentPagerListener();
        if (fragmentPagerListener != null) {
            fragmentPagerListener.onForeground();
        }
        return true;
    }

    public boolean clear() {
        if (!this.hasPage()) {
            return false;
        }
        int id = this.fragmentManager.getBackStackEntryAt(0).getId();
        this.fragmentManager.popBackStackImmediate(id, 1);
        FragmentPagerLifeCycleFragment fragmentPagerListener = this.getLastFragmentPagerListener();
        if (fragmentPagerListener != null) {
            fragmentPagerListener.onForeground();
        }
        return true;
    }

    public void add(Fragment newFragment) {
        this.add(newFragment, null);
    }

    public void add(Fragment newFragment, FragmentPagerTransitionInterceptor eachFragmentPagerTransitionInterceptor) {
        FragmentPagerLifeCycleFragment lastFragmentPagerListener = this.getLastFragmentPagerListener();
        if (lastFragmentPagerListener != null) {
            lastFragmentPagerListener.onBackground();
        }
        FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
        fragmentTransaction.add(this.containerViewId, newFragment, newFragment.getClass().getName()).addToBackStack(newFragment.getClass().getName());
        FragmentPagerTransitionInterceptor globalFragmentPagerInterceptor = FragmentStack.getGlobalFragmentPagerTransitionInterceptor();
        if (globalFragmentPagerInterceptor != null) {
            globalFragmentPagerInterceptor.onTransaction(this, fragmentTransaction);
        }
        if (this.localFragmentPagerTransitionInterceptor != null) {
            this.localFragmentPagerTransitionInterceptor.onTransaction(this, fragmentTransaction);
        }
        if (eachFragmentPagerTransitionInterceptor != null) {
            eachFragmentPagerTransitionInterceptor.onTransaction(this, fragmentTransaction);
        }
        fragmentTransaction.commit();
    }

    public FragmentPagerLifeCycleFragment getLastFragmentPagerListener() {
        Fragment lastFragment = this.getLastFragment();
        if (lastFragment instanceof FragmentPagerLifeCycleFragment) {
            return (FragmentPagerLifeCycleFragment)lastFragment;
        }
        return null;
    }

    public Fragment getLastFragment() {
        int index = this.fragmentManager.getBackStackEntryCount() - 1;
        if (index == -1) {
            return this.defaultFragment;
        }
        FragmentManager.BackStackEntry backEntry = this.fragmentManager.getBackStackEntryAt(index);
        String tag = backEntry.getName();
        return this.fragmentManager.findFragmentByTag(tag);
    }
}

