/*
 * Decompiled with CFR 0.152.
 */
package io.github.onewater.autohintedittext.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.EditText;

public class SuffixEditText
extends EditText {
    protected ColorStateList mSuffixTextColor;
    protected String mSuffix = "";
    private int mPaintAlpha = 255;

    public SuffixEditText(Context context) {
        super(context);
    }

    public SuffixEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SuffixEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSuffix != null && this.getText().length() > 0) {
            TextPaint mPaint = this.getPaint();
            mPaint.setColor(this.mSuffixTextColor.getColorForState(this.getDrawableState(), 0));
            mPaint.setAlpha(this.mPaintAlpha);
            int lineBaseline = this.getLineBounds(0, null);
            canvas.drawText(this.mSuffix, this.getPaint().measureText(this.getText().toString()) + (float)this.getPaddingLeft(), (float)(canvas.getClipBounds().top + lineBaseline), (Paint)mPaint);
        }
    }

    public void setSuffixTextAlpha(int paintAlpha) {
        this.mPaintAlpha = paintAlpha;
    }

    public void setSuffixTextColor(ColorStateList suffixTextColor) {
        this.mSuffixTextColor = suffixTextColor;
    }

    public void setSuffix(String suffix) {
        this.mSuffix = suffix;
        this.invalidate();
    }
}

