/*
 * Decompiled with CFR 0.152.
 */
package io.github.onewater.autohintedittext;

import android.support.annotation.ArrayRes;
import io.github.onewater.autohintedittext.HintWatcher;
import io.github.onewater.autohintedittext.widget.AutoHintEditText;
import java.util.HashMap;

public class EmailHintWatcher
extends HintWatcher {
    private String[] mSuffixData = new String[0];
    private HashMap<String, String> mSuffixMap = new HashMap();

    public EmailHintWatcher(AutoHintEditText editText) {
        super(editText);
    }

    public void setSuffixData(@ArrayRes int resId) {
        this.mSuffixData = this.mEditText.getResources().getStringArray(resId);
        this.createSuffixMap();
    }

    public void setSuffixData(String[] array) {
        this.mSuffixData = array;
        this.createSuffixMap();
    }

    void createSuffixMap() {
        for (int i = 0; i < this.mSuffixData.length; ++i) {
            String value = this.mSuffixData[i];
            for (int j = 2; j < value.length(); ++j) {
                this.mSuffixMap.put(value.substring(1, j), value.substring(j, value.length()));
            }
        }
    }

    @Override
    public void check(String s) {
        int atIndex = s.indexOf(64);
        if (atIndex != -1) {
            String suffix = s.substring(atIndex + 1);
            this.setSuffix(this.mSuffixMap.containsKey(suffix) ? this.mSuffixMap.get(suffix) : "");
        } else {
            this.setSuffix("");
        }
    }
}

