/*
 * Decompiled with CFR 0.152.
 */
package io.github.onewater.autohintedittext.widget;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import io.github.onewater.autohintedittext.HintWatcher;
import io.github.onewater.autohintedittext.widget.SuffixEditText;
import java.util.ArrayList;
import java.util.List;

public class AutoHintEditText
extends SuffixEditText
implements View.OnFocusChangeListener {
    List<HintWatcher> hintWatcherList = new ArrayList<HintWatcher>();

    public AutoHintEditText(Context context) {
        super(context);
        this.init(context);
    }

    public AutoHintEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AutoHintEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setOnFocusChangeListener(this);
        this.setSuffixTextColor(this.getTextColors());
        this.setSuffixTextAlpha(127);
        this.addTextChangedListener(new MyTextWatcher());
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (!hasFocus) {
            this.append(this.mSuffix);
            this.mSuffix = "";
        }
    }

    public void addHintWatcher(HintWatcher hintWatcher) {
        this.hintWatcherList.add(hintWatcher);
    }

    class MyTextWatcher
    implements TextWatcher {
        MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            for (int i = 0; i < AutoHintEditText.this.hintWatcherList.size(); ++i) {
                AutoHintEditText.this.hintWatcherList.get(i).check(s.toString());
            }
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

