/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.base58;

import io.github.novacrypto.base58.WorkingBuffer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

final class SecureWorkingBuffer
implements WorkingBuffer {
    private ByteBuffer bytes;
    private byte[] key = new byte[1021];

    SecureWorkingBuffer() {
        new SecureRandom().nextBytes(this.key);
    }

    @Override
    public void setCapacity(int atLeast) {
        this.bytes = this.ensureCapacity(this.bytes, atLeast);
        this.clear(this.bytes);
    }

    @Override
    public byte get(int index) {
        this.assertIndexValid(index);
        return this.encodeDecode(this.bytes.get(index), index);
    }

    @Override
    public void put(int index, byte value) {
        this.assertIndexValid(index);
        this.bytes.put(index, this.encodeDecode(value, index));
    }

    @Override
    public void clear() {
        this.clear(this.bytes);
    }

    private void assertIndexValid(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private int capacity() {
        return this.bytes == null ? 0 : this.bytes.capacity();
    }

    private ByteBuffer ensureCapacity(ByteBuffer bytes, int atLeast) {
        if (bytes != null && bytes.capacity() >= atLeast) {
            return bytes;
        }
        if (bytes != null) {
            this.clear(bytes);
        }
        return ByteBuffer.allocateDirect(atLeast);
    }

    private void clear(ByteBuffer bytes) {
        bytes.position(0);
        int capacity = bytes.capacity();
        for (int i = 0; i < capacity; ++i) {
            bytes.put(i, this.encodeDecode((byte)-1, i));
        }
    }

    private byte encodeDecode(byte b, int index) {
        return (byte)(b ^ this.key[index % this.key.length]);
    }
}

