/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.base58;

import io.github.novacrypto.base58.WorkingBuffer;
import java.util.Arrays;

final class ByteArrayWorkingBuffer
implements WorkingBuffer {
    private static byte[] EMPTY = new byte[0];
    private byte[] bytes = EMPTY;

    ByteArrayWorkingBuffer() {
    }

    @Override
    public void setCapacity(int atLeast) {
        this.bytes = ByteArrayWorkingBuffer.ensureCapacity(this.bytes, atLeast);
        ByteArrayWorkingBuffer.clear(this.bytes);
    }

    @Override
    public byte get(int index) {
        return this.bytes[index];
    }

    @Override
    public void put(int index, byte value) {
        this.bytes[index] = value;
    }

    @Override
    public void clear() {
        ByteArrayWorkingBuffer.clear(this.bytes);
    }

    private static byte[] ensureCapacity(byte[] bytes, int atLeast) {
        if (bytes.length >= atLeast) {
            return bytes;
        }
        ByteArrayWorkingBuffer.clear(bytes);
        return new byte[atLeast];
    }

    private static void clear(byte[] bytes) {
        Arrays.fill(bytes, (byte)-1);
    }
}

