/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.base58;

import io.github.novacrypto.base58.BadCharacterException;
import io.github.novacrypto.base58.ByteArrayTarget;
import io.github.novacrypto.base58.DecodeTarget;
import io.github.novacrypto.base58.DecodeWriter;
import io.github.novacrypto.base58.EncodeTarget;
import io.github.novacrypto.base58.GeneralEncoderDecoder;
import io.github.novacrypto.base58.StringBuilderEncodeTarget;
import io.github.novacrypto.base58.WorkingBuffer;
import java.util.Arrays;

final class Base58EncoderDecoder
implements GeneralEncoderDecoder {
    private static final char[] DIGITS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final int[] VALUES = Base58EncoderDecoder.initValues(DIGITS);
    private final WorkingBuffer workingBuffer;

    Base58EncoderDecoder(WorkingBuffer workingBuffer) {
        this.workingBuffer = workingBuffer;
    }

    @Override
    public String encode(byte[] bytes) {
        StringBuilderEncodeTarget target = new StringBuilderEncodeTarget();
        this.encode(bytes, target);
        return target.toString();
    }

    private WorkingBuffer getBufferOfAtLeastBytes(int atLeast) {
        this.workingBuffer.setCapacity(atLeast);
        return this.workingBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(byte[] bytes, EncodeTarget target) {
        char[] a = DIGITS;
        int bLen = bytes.length;
        WorkingBuffer d = this.getBufferOfAtLeastBytes(bLen << 1);
        try {
            int dlen = -1;
            int blanks = 0;
            int j = 0;
            for (int i = 0; i < bLen; ++i) {
                int c = bytes[i] & 0xFF;
                if (c == 0 && blanks == i) {
                    target.append(a[0]);
                    ++blanks;
                }
                for (j = 0; j <= dlen || c != 0; ++j) {
                    int n;
                    if (j > dlen) {
                        dlen = j;
                        n = c;
                    } else {
                        n = d.get(j);
                        n = (n << 8) + c;
                    }
                    d.put(j, (byte)(n % 58));
                    c = n / 58;
                }
            }
            while (j-- > 0) {
                target.append(a[d.get(j)]);
            }
        }
        finally {
            d.clear();
        }
    }

    @Override
    public byte[] decode(CharSequence base58) {
        ByteArrayTarget target = new ByteArrayTarget();
        this.decode(base58, target);
        return target.asByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(CharSequence base58, DecodeTarget target) {
        int strLen = base58.length();
        WorkingBuffer d = this.getBufferOfAtLeastBytes(strLen);
        try {
            int dlen = -1;
            int blanks = 0;
            int j = 0;
            for (int i = 0; i < strLen; ++i) {
                j = 0;
                char charAtI = base58.charAt(i);
                int c = Base58EncoderDecoder.valueOf(charAtI);
                if (c < 0) {
                    throw new BadCharacterException(charAtI);
                }
                if (c == 0 && blanks == i) {
                    ++blanks;
                }
                while (j <= dlen || c != 0) {
                    int n;
                    if (j > dlen) {
                        dlen = j;
                        n = c;
                    } else {
                        n = d.get(j) & 0xFF;
                        n = n * 58 + c;
                    }
                    d.put(j, (byte)n);
                    c = n >>> 8;
                    ++j;
                }
            }
            int outputLength = j + blanks;
            DecodeWriter writer = target.getWriterForLength(outputLength);
            for (int i = 0; i < blanks; ++i) {
                writer.append((byte)0);
            }
            int end = outputLength - 1;
            for (int i = blanks; i < outputLength; ++i) {
                writer.append(d.get(end - i));
            }
        }
        finally {
            d.clear();
        }
    }

    private static int[] initValues(char[] alphabet) {
        int[] lookup = new int[123];
        Arrays.fill(lookup, -1);
        for (int i = 0; i < alphabet.length; ++i) {
            lookup[alphabet[i]] = i;
        }
        return lookup;
    }

    private static int valueOf(char base58Char) {
        if (base58Char >= VALUES.length) {
            return -1;
        }
        return VALUES[base58Char];
    }
}

