/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.base58;

import io.github.novacrypto.base58.Base58EncoderDecoder;
import io.github.novacrypto.base58.ByteArrayWorkingBuffer;
import io.github.novacrypto.base58.EncoderDecoder;
import io.github.novacrypto.base58.GeneralEncoderDecoder;
import io.github.novacrypto.base58.SecureEncoderDecoder;
import io.github.novacrypto.base58.SecureWorkingBuffer;
import io.github.novacrypto.base58.WorkingBuffer;

public final class Base58 {
    private static final ThreadLocal<EncoderDecoder> working = new ThreadLocal();

    Base58() {
    }

    public static GeneralEncoderDecoder newInstanceWithBuffer(WorkingBuffer workingBuffer) {
        return new Base58EncoderDecoder(workingBuffer);
    }

    public static EncoderDecoder newInstance() {
        return Base58.newInstanceWithBuffer(new ByteArrayWorkingBuffer());
    }

    public static SecureEncoderDecoder newSecureInstance() {
        return Base58.newInstanceWithBuffer(new SecureWorkingBuffer());
    }

    public static String base58Encode(byte[] bytes) {
        return Base58.getThreadSharedBase58().encode(bytes);
    }

    public static byte[] base58Decode(CharSequence base58) {
        return Base58.getThreadSharedBase58().decode(base58);
    }

    private static EncoderDecoder getThreadSharedBase58() {
        EncoderDecoder base58 = working.get();
        if (base58 == null) {
            base58 = Base58.newInstance();
            working.set(base58);
        }
        return base58;
    }
}

